/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.documentation;

import ai.vespa.schemals.documentation.RankFeatureDocumentationFetcher;
import ai.vespa.schemals.documentation.SchemaDocumentationFetcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FetchDocumentation {
    private static final String SCHEMA_URL = "en/reference/schema-reference.html";
    private static final String RANK_FEATURE_URL = "en/reference/rank-features.html";
    private static final Map<String, List<String>> REPLACE_FILENAME_MAP = new HashMap<String, List<String>>(){
        {
            this.put("EXPRESSION", List.of("EXPRESSION_SL", "EXPRESSION_ML"));
            this.put("RANK_FEATURES", List.of("RANKFEATURES_SL", "RANKFEATURES_ML"));
            this.put("FUNCTION (INLINE)? [NAME]", List.of("FUNCTION"));
            this.put("SUMMARY_FEATURES", List.of("SUMMARYFEATURES_SL", "SUMMARYFEATURES_ML", "SUMMARYFEATURES_ML_INHERITS"));
            this.put("MATCH_FEATURES", List.of("MATCHFEATURES_SL", "MATCHFEATURES_ML", "MATCHFEATURES_SL_INHERITS"));
            this.put("IMPORT FIELD", List.of("IMPORT"));
        }
    };

    public static void fetchDocs(Path targetPath) throws IOException {
        Files.createDirectories(targetPath, new FileAttribute[0]);
        Files.createDirectories(targetPath.resolve("schema"), new FileAttribute[0]);
        Files.createDirectories(targetPath.resolve("rankExpression"), new FileAttribute[0]);
        Path writePath = targetPath.resolve("schema");
        Map<String, String> schemaMarkdownContent = new SchemaDocumentationFetcher(SCHEMA_URL).getMarkdownContent();
        for (Map.Entry<String, String> entry : schemaMarkdownContent.entrySet()) {
            String fileName = FetchDocumentation.convertToToken(entry.getKey());
            String content = entry.getValue();
            if (REPLACE_FILENAME_MAP.containsKey(fileName)) {
                for (String replacedFileName : REPLACE_FILENAME_MAP.get(fileName)) {
                    Files.write(writePath.resolve(replacedFileName + ".md"), content.getBytes(), StandardOpenOption.CREATE);
                }
                continue;
            }
            Files.write(writePath.resolve(fileName + ".md"), content.getBytes(), StandardOpenOption.CREATE);
        }
        Map<String, String> rankFeatureMarkdownContent = new RankFeatureDocumentationFetcher(RANK_FEATURE_URL).getMarkdownContent();
        writePath = targetPath.resolve("rankExpression");
        for (Map.Entry<String, String> entry : rankFeatureMarkdownContent.entrySet()) {
            Files.write(writePath.resolve(entry.getKey() + ".md"), entry.getValue().getBytes(), StandardOpenOption.CREATE);
        }
    }

    private static String convertToToken(String h2Id) {
        return h2Id.toUpperCase().replaceAll("-", "_");
    }

    public static void main(String[] args2) {
        if (args2.length < 1) {
            System.err.println("FetchDocumentation requires one argument: <path-to-write-docs>");
            System.exit(1);
        }
        Path targetPath = Paths.get(args2[0], new String[0]);
        try {
            System.out.println("Fetching docs to " + args2[0]);
            FetchDocumentation.fetchDocs(targetPath);
        }
        catch (IOException ex) {
            System.err.println("FetchDocumentation failed to download documentation: " + ex.getMessage());
            System.exit(1);
        }
    }
}

