/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;

public class EnumArgument
implements Argument {
    String displayString;
    List<String> validArguments;

    public EnumArgument(String displayString, List<String> validArguments) {
        this.validArguments = List.copyOf(validArguments);
        this.displayString = displayString;
    }

    public List<String> getValidArguments() {
        return this.validArguments;
    }

    @Override
    public Optional<Diagnostic> parseArgument(ParseContext context, RankNode node) {
        if (!this.validateArgument(node)) {
            return Optional.empty();
        }
        RankNode leaf = node;
        while (leaf.getChildren().size() > 0) {
            leaf = leaf.getChildren().get(0);
        }
        Symbol symbol = leaf.getSymbol();
        if (symbol == null) {
            return Optional.empty();
        }
        if (symbol.getStatus() == Symbol.SymbolStatus.REFERENCE) {
            context.schemaIndex().deleteSymbolReference(symbol);
        }
        symbol.setType(Symbol.SymbolType.DIMENSION);
        symbol.setStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
        return Optional.empty();
    }

    @Override
    public boolean validateArgument(RankNode node) {
        return this.validArguments.contains(node.getSchemaNode().getText());
    }

    @Override
    public int getStrictness() {
        return 5;
    }

    @Override
    public String displayString() {
        return this.displayString;
    }
}

