## schema

The root element of schemas. A schema describes a type of data and what we should compute over it. A schema must be defined in a file named `[schema-name].sd`.

```
schema [name] inherits [name] {
    [body]
}
```

The `inherits` attribute is optional. If a schema is inherited, this schema will include all the constructs of it as if they were defined in this (except the parent document type). The document type in this must declare that it inherits the document type of the parent schema.

The body is mandatory and may contain:

|                                                     Name                                                      |  Occurrence  |                                                                                                                                                                 Description                                                                                                                                                                 |
|---------------------------------------------------------------------------------------------------------------|--------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [document](https://docs.vespa.ai/en/reference/schema-reference.html#document)                                 | One          | A document type defined in this schema                                                                                                                                                                                                                                                                                                      |
| [field](https://docs.vespa.ai/en/reference/schema-reference.html#field)                                       | Zero to many | A field not contained in the document. Use *synthetic fields* (outside [document](https://docs.vespa.ai/en/reference/schema-reference.html#document)) to derive new field values to be placed in the indexing structure from document fields. Find examples in [reindexing](https://docs.vespa.ai/en/operations/reindexing.html#use-cases). |
| [fieldset](https://docs.vespa.ai/en/reference/schema-reference.html#fieldset)                                 | Zero to many | Group document fields together for searching                                                                                                                                                                                                                                                                                                |
| [rank-profile](https://docs.vespa.ai/en/reference/schema-reference.html#rank-profile)                         | Zero to many | A bundle of ranking functions and settings, selectable in a query.                                                                                                                                                                                                                                                                          |
| [constant](https://docs.vespa.ai/en/reference/schema-reference.html#constant)                                 | Zero to many | A constant tensor located in a file used for ranking                                                                                                                                                                                                                                                                                        |
| [onnx-model](https://docs.vespa.ai/en/reference/schema-reference.html#onnx-model)                             | Zero to many | An ONNX model located in the application package used for ranking                                                                                                                                                                                                                                                                           |
| [stemming](https://docs.vespa.ai/en/reference/schema-reference.html#stemming)                                 | Zero or one  | The default stemming setting.                                                                                                                                                                                                                                                                                                               |
| [raw-as-base64-in-summary](https://docs.vespa.ai/en/reference/schema-reference.html#raw-as-base64-in-summary) | Zero or one  | Base64 encode raw fields in summary rather than using an escaped string. Default is true.                                                                                                                                                                                                                                                   |
| [document-summary](https://docs.vespa.ai/en/reference/schema-reference.html#document-summary)                 | Zero to many | An explicitly defined document summary                                                                                                                                                                                                                                                                                                      |
| [annotation](https://docs.vespa.ai/en/reference/schema-reference.html#annotation)                             | Zero to many | Defines an annotation type                                                                                                                                                                                                                                                                                                                  |
| [import field](https://docs.vespa.ai/en/reference/schema-reference.html#import-field)                         | Zero to many | Import a field value from a global document                                                                                                                                                                                                                                                                                                 |

[Read more](https://docs.vespa.ai/en/reference/schema-reference.html#schema)
