/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.STRUCT_FIELD;
import ai.vespa.schemals.parser.ast.fieldBodyElm;
import ai.vespa.schemals.parser.ast.identifierStr;
import ai.vespa.schemals.parser.ast.structFieldBodyElm;
import ai.vespa.schemals.parser.ast.structFieldElm;
import ai.vespa.schemals.schemadocument.resolvers.SymbolReferenceResolver;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;

public class StructFieldDefinitionResolver {
    public static List<Diagnostic> resolve(ParseContext context, SchemaNode CST) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        StructFieldDefinitionResolver.traverse(context, CST, diagnostics);
        return diagnostics;
    }

    private static void traverse(ParseContext context, SchemaNode node, List<Diagnostic> diagnostics) {
        if (node.getParent() != null && node.isASTInstance(identifierStr.class) && node.getParent().isASTInstance(structFieldElm.class)) {
            StructFieldDefinitionResolver.handleStructField(context, node, diagnostics);
        }
        for (SchemaNode child : node) {
            StructFieldDefinitionResolver.traverse(context, child, diagnostics);
        }
    }

    private static void handleStructField(ParseContext context, SchemaNode node, List<Diagnostic> diagnostics) {
        SchemaNode prev = node.getPreviousSibling();
        if (prev.isASTInstance(STRUCT_FIELD.class)) {
            SchemaNode enclosingBodyNode = node.getParent().getParent();
            if (enclosingBodyNode.isASTInstance(fieldBodyElm.class)) {
                SchemaNode fieldIdentifierNode = enclosingBodyNode.getParent().get(1);
                if (!fieldIdentifierNode.hasSymbol() || fieldIdentifierNode.getSymbol().getStatus() != Symbol.SymbolStatus.DEFINITION) {
                    return;
                }
                Optional<Symbol> subfieldInParent = SymbolReferenceResolver.resolveSubFieldReference(node, fieldIdentifierNode.getSymbol(), context, diagnostics);
                if (subfieldInParent.isEmpty()) {
                    return;
                }
                Symbol scope = fieldIdentifierNode.getSymbol();
                StructFieldDefinitionResolver.createStructFieldDefinition(context, scope, node, subfieldInParent.get());
            } else if (enclosingBodyNode.isASTInstance(structFieldBodyElm.class)) {
                SchemaNode lastStructFieldIdentifier = enclosingBodyNode.getParent().get(1);
                while (lastStructFieldIdentifier.getNextSibling() != null && lastStructFieldIdentifier.getNextSibling().isASTInstance(identifierStr.class)) {
                    lastStructFieldIdentifier = lastStructFieldIdentifier.getNextSibling();
                }
                if (!lastStructFieldIdentifier.hasSymbol() || lastStructFieldIdentifier.getSymbol().getStatus() != Symbol.SymbolStatus.DEFINITION) {
                    return;
                }
                Optional<Symbol> referredParentFieldDefinition = context.schemaIndex().getFirstSymbolDefinition(lastStructFieldIdentifier.getSymbol());
                if (referredParentFieldDefinition.isEmpty()) {
                    return;
                }
                Optional<Symbol> subfieldInParent = SymbolReferenceResolver.resolveSubFieldReference(node, referredParentFieldDefinition.get(), context, diagnostics);
                if (subfieldInParent.isEmpty()) {
                    return;
                }
                Symbol scope = lastStructFieldIdentifier.getSymbol();
                StructFieldDefinitionResolver.createStructFieldDefinition(context, scope, node, subfieldInParent.get());
            }
        } else if (prev.hasSymbol() && prev.getSymbol().getStatus() == Symbol.SymbolStatus.DEFINITION) {
            Optional<Symbol> referredParentFieldDefinition = context.schemaIndex().getFirstSymbolDefinition(prev.getSymbol());
            if (referredParentFieldDefinition.isEmpty()) {
                return;
            }
            Optional<Symbol> subfieldInParent = SymbolReferenceResolver.resolveSubFieldReference(node, referredParentFieldDefinition.get(), context, diagnostics);
            if (subfieldInParent.isEmpty()) {
                return;
            }
            Symbol scope = prev.getSymbol();
            StructFieldDefinitionResolver.createStructFieldDefinition(context, scope, node, subfieldInParent.get());
        }
    }

    private static void createStructFieldDefinition(ParseContext context, Symbol scope, SchemaNode node, Symbol referenceToField) {
        node.setSymbolStatus(Symbol.SymbolStatus.DEFINITION);
        node.setSymbolType(Symbol.SymbolType.FIELD);
        node.setSymbolScope(scope);
        context.schemaIndex().insertSymbolDefinition(node.getSymbol());
        context.schemaIndex().insertSymbolReference(referenceToField, node.getSymbol());
    }
}

