/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.utils;

import com.yahoo.document.predicate.Predicate;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.function.Consumer;

public class VespaFeedParser {
    public static int parseDocuments(String feedFile, int maxDocuments, Consumer<Predicate> consumer) throws IOException {
        int documentCount = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(feedFile), 8192);){
            reader.readLine();
            reader.readLine();
            String line = reader.readLine();
            while (!line.startsWith("</vespafeed>") && documentCount < maxDocuments) {
                while (!line.startsWith("<boolean>")) {
                    line = reader.readLine();
                }
                Predicate predicate = Predicate.fromString((String)VespaFeedParser.extractBooleanExpression(line));
                consumer.accept(predicate);
                ++documentCount;
                while (!line.startsWith("<document") && !line.startsWith("</vespafeed>")) {
                    line = reader.readLine();
                }
            }
        }
        return documentCount;
    }

    private static String extractBooleanExpression(String line) {
        return line.substring(9, line.length() - 10);
    }
}

