/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import java.util.stream.Stream;

public final class IntervalWithBounds {
    private int[] intervalBoundsArray;
    private int arrayIndex;

    public IntervalWithBounds() {
        this.setIntervalArray(null, 0);
    }

    public IntervalWithBounds(int interval, int bounds) {
        this.setIntervalArray(new int[]{interval, bounds}, 0);
    }

    public void setIntervalArray(int[] intervalBoundsArray, int arrayIndex) {
        this.intervalBoundsArray = intervalBoundsArray;
        this.arrayIndex = arrayIndex;
    }

    public boolean hasValue() {
        return this.arrayIndex < this.intervalBoundsArray.length - 1;
    }

    public void nextValue() {
        this.arrayIndex += 2;
    }

    public Stream<Integer> stream() {
        return Stream.of(this.getInterval(), this.getBounds());
    }

    public int getInterval() {
        return this.intervalBoundsArray[this.arrayIndex];
    }

    public int getBounds() {
        return this.intervalBoundsArray[this.arrayIndex + 1];
    }

    public boolean contains(int value) {
        int bounds = this.getBounds();
        if ((bounds & Integer.MIN_VALUE) != 0) {
            return value >= (bounds & 0x3FFFFFFF);
        }
        if ((bounds & 0x40000000) != 0) {
            return value < (bounds & 0x3FFFFFFF);
        }
        return value >= bounds >> 16 && value < (bounds & 0xFFFF);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalWithBounds that = (IntervalWithBounds)o;
        return this.getInterval() == that.getInterval() && this.getBounds() == that.getBounds();
    }

    public int hashCode() {
        return 31 * this.getInterval() + this.getBounds();
    }

    public String toString() {
        return "IntervalWithBounds{interval=" + this.getInterval() + ", bounds=" + this.getBounds() + "}";
    }
}

