/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import com.yahoo.document.predicate.Predicate;
import com.yahoo.search.predicate.Config;
import com.yahoo.search.predicate.optimization.AndOrSimplifier;
import com.yahoo.search.predicate.optimization.BooleanSimplifier;
import com.yahoo.search.predicate.optimization.ComplexNodeTransformer;
import com.yahoo.search.predicate.optimization.FeatureConjunctionTransformer;
import com.yahoo.search.predicate.optimization.NotNodeReorderer;
import com.yahoo.search.predicate.optimization.OrSimplifier;
import com.yahoo.search.predicate.optimization.PredicateOptions;
import com.yahoo.search.predicate.optimization.PredicateProcessor;

public class PredicateOptimizer {
    private final PredicateProcessor[] processors;
    private final PredicateOptions options;

    public PredicateOptimizer(Config config) {
        this.options = new PredicateOptions(config.arity, Long.valueOf(config.lowerBound), Long.valueOf(config.upperBound));
        this.processors = new PredicateProcessor[]{new AndOrSimplifier(), new BooleanSimplifier(), new ComplexNodeTransformer(), new OrSimplifier(), new NotNodeReorderer(), new FeatureConjunctionTransformer(config.useConjunctionAlgorithm)};
    }

    public Predicate optimizePredicate(Predicate predicate) {
        for (PredicateProcessor processor : this.processors) {
            predicate = processor.process(predicate, this.options);
        }
        return predicate;
    }
}

