/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.utils;

import com.yahoo.document.predicate.Predicate;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.function.Consumer;

public class VespaFeedParser {
    public static int parseDocuments(String feedFile, int maxDocuments, Consumer<Predicate> consumer) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(feedFile), 8192);){
            reader.mark(1);
            String line = reader.readLine();
            boolean xmlFeed = line.startsWith("<");
            reader.reset();
            int n = xmlFeed ? VespaFeedParser.parseXmlFeedFile(reader, maxDocuments, consumer) : VespaFeedParser.parseJsonFeedFile(reader, maxDocuments, consumer);
            return n;
        }
    }

    public static int parseJsonFeedFile(BufferedReader reader, int maxDocuments, Consumer<Predicate> consumer) throws IOException {
        int documentCount;
        String line = reader.readLine();
        for (documentCount = 0; !line.startsWith("]") && documentCount < maxDocuments; ++documentCount) {
            while (!line.contains("\"boolean\":")) {
                line = reader.readLine();
            }
            String booleanExpression = VespaFeedParser.extractBooleanExpression(line);
            try {
                Predicate predicate = Predicate.fromString((String)booleanExpression);
                consumer.accept(predicate);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to parse predicate: " + booleanExpression, e);
            }
            line = reader.readLine();
        }
        return documentCount;
    }

    public static int parseXmlFeedFile(BufferedReader reader, int maxDocuments, Consumer<Predicate> consumer) throws IOException {
        int documentCount = 0;
        reader.readLine();
        String line = reader.readLine();
        while (!line.startsWith("</vespafeed>") && documentCount < maxDocuments) {
            while (!line.startsWith("<boolean>")) {
                line = reader.readLine();
            }
            Predicate predicate = Predicate.fromString((String)VespaFeedParser.extractBooleanExpressionXml(line));
            consumer.accept(predicate);
            ++documentCount;
            while (!line.startsWith("<document") && !line.startsWith("</vespafeed>")) {
                line = reader.readLine();
            }
            line = reader.readLine();
            if (line != null) continue;
            break;
        }
        return documentCount;
    }

    private static String extractBooleanExpression(String line) {
        String field = "\"boolean\":";
        int start = line.indexOf(field);
        int end = line.indexOf("\"", start + field.length() + 1);
        return line.substring(start + field.length() + 1, end);
    }

    private static String extractBooleanExpressionXml(String line) {
        return line.substring(9, line.length() - 10);
    }
}

