/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.utils;

import com.yahoo.document.predicate.Predicate;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.function.Consumer;

public class VespaFeedParser {
    public static int parseDocuments(String feedFile, int maxDocuments, Consumer<Predicate> consumer) throws IOException {
        int documentCount;
        try (BufferedReader reader = new BufferedReader(new FileReader(feedFile), 8192);){
            String line = reader.readLine();
            for (documentCount = 0; !line.startsWith("]") && documentCount < maxDocuments; ++documentCount) {
                while (!line.contains("\"boolean\":")) {
                    line = reader.readLine();
                }
                String booleanExpression = VespaFeedParser.extractBooleanExpression(line);
                try {
                    Predicate predicate = Predicate.fromString((String)booleanExpression);
                    consumer.accept(predicate);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Failed to parse predicate: " + booleanExpression, e);
                }
                line = reader.readLine();
            }
        }
        return documentCount;
    }

    private static String extractBooleanExpression(String line) {
        String field = "\"boolean\":";
        int start = line.indexOf(field);
        int end = line.indexOf("\"", start + field.length() + 1);
        return line.substring(start + field.length() + 1, end);
    }
}

