/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate;

import com.yahoo.api.annotations.Beta;
import com.yahoo.search.predicate.Config;
import com.yahoo.search.predicate.Hit;
import com.yahoo.search.predicate.PredicateQuery;
import com.yahoo.search.predicate.index.BoundsPostingList;
import com.yahoo.search.predicate.index.CachedPostingListCounter;
import com.yahoo.search.predicate.index.Feature;
import com.yahoo.search.predicate.index.IntervalPostingList;
import com.yahoo.search.predicate.index.PostingList;
import com.yahoo.search.predicate.index.PredicateIntervalStore;
import com.yahoo.search.predicate.index.PredicateRangeTermExpander;
import com.yahoo.search.predicate.index.PredicateSearch;
import com.yahoo.search.predicate.index.SimpleIndex;
import com.yahoo.search.predicate.index.ZeroConstraintPostingList;
import com.yahoo.search.predicate.index.ZstarCompressedPostingList;
import com.yahoo.search.predicate.index.conjunction.ConjunctionHit;
import com.yahoo.search.predicate.index.conjunction.ConjunctionIndex;
import com.yahoo.search.predicate.serialization.SerializationHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

@Beta
public class PredicateIndex {
    private static final int SERIALIZATION_FORMAT_VERSION = 3;
    private final PredicateRangeTermExpander expander;
    private final int[] internalToExternalIdMapping;
    private final byte[] minFeatureIndex;
    private final short[] intervalEnds;
    private final int highestIntervalEnd;
    private final SimpleIndex intervalIndex;
    private final SimpleIndex boundsIndex;
    private final SimpleIndex conjunctionIntervalIndex;
    private final PredicateIntervalStore intervalStore;
    private final ConjunctionIndex conjunctionIndex;
    private final int[] zeroConstraintDocuments;
    private final Config config;
    private final AtomicReference<CachedPostingListCounter> postingListCounter;

    PredicateIndex(Config config, int[] internalToExternalIdMapping, byte[] minFeatureIndex, short[] intervalEnds, int highestIntervalEnd, SimpleIndex intervalIndex, SimpleIndex boundsIndex, SimpleIndex conjunctionIntervalIndex, PredicateIntervalStore intervalStore, ConjunctionIndex conjunctionIndex, int[] zeroConstraintDocuments) {
        this.internalToExternalIdMapping = internalToExternalIdMapping;
        this.minFeatureIndex = minFeatureIndex;
        this.intervalEnds = intervalEnds;
        this.highestIntervalEnd = highestIntervalEnd;
        this.intervalIndex = intervalIndex;
        this.boundsIndex = boundsIndex;
        this.conjunctionIntervalIndex = conjunctionIntervalIndex;
        this.intervalStore = intervalStore;
        this.conjunctionIndex = conjunctionIndex;
        this.zeroConstraintDocuments = zeroConstraintDocuments;
        this.expander = new PredicateRangeTermExpander(config.arity, config.lowerBound, config.upperBound);
        this.config = config;
        this.postingListCounter = new AtomicReference<CachedPostingListCounter>(new CachedPostingListCounter(internalToExternalIdMapping.length));
    }

    public void rebuildPostingListCache() {
        this.postingListCounter.getAndUpdate(CachedPostingListCounter::rebuildCache);
    }

    public Searcher searcher() {
        return new Searcher();
    }

    public void writeToOutputStream(DataOutputStream out) throws IOException {
        out.writeInt(3);
        this.config.writeToOutputStream(out);
        SerializationHelper.writeIntArray(this.internalToExternalIdMapping, out);
        SerializationHelper.writeByteArray(this.minFeatureIndex, out);
        SerializationHelper.writeShortArray(this.intervalEnds, out);
        out.writeInt(this.highestIntervalEnd);
        SerializationHelper.writeIntArray(this.zeroConstraintDocuments, out);
        this.intervalIndex.writeToOutputStream(out);
        this.boundsIndex.writeToOutputStream(out);
        this.conjunctionIntervalIndex.writeToOutputStream(out);
        this.intervalStore.writeToOutputStream(out);
        this.conjunctionIndex.writeToOutputStream(out);
    }

    public static PredicateIndex fromInputStream(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version != 3) {
            throw new IllegalArgumentException(String.format("Invalid serialization format version. Expected %d, was %d.", 3, version));
        }
        Config config = Config.fromInputStream(in);
        int[] internalToExternalIdMapping = SerializationHelper.readIntArray(in);
        byte[] minFeatureIndex = SerializationHelper.readByteArray(in);
        short[] intervalEnds = SerializationHelper.readShortArray(in);
        int highestIntervalEnd = in.readInt();
        int[] zeroConstraintDocuments = SerializationHelper.readIntArray(in);
        SimpleIndex intervalIndex = SimpleIndex.fromInputStream(in);
        SimpleIndex boundsIndex = SimpleIndex.fromInputStream(in);
        SimpleIndex conjunctionIntervalIndex = SimpleIndex.fromInputStream(in);
        PredicateIntervalStore intervalStore = PredicateIntervalStore.fromInputStream(in);
        ConjunctionIndex conjunctionIndex = ConjunctionIndex.fromInputStream(in);
        return new PredicateIndex(config, internalToExternalIdMapping, minFeatureIndex, intervalEnds, highestIntervalEnd, intervalIndex, boundsIndex, conjunctionIntervalIndex, intervalStore, conjunctionIndex, zeroConstraintDocuments);
    }

    @Beta
    public class Searcher {
        private final byte[] nPostingListsForDocument;
        private final ConjunctionIndex.Searcher conjunctionIndexSearcher;

        private Searcher() {
            this.nPostingListsForDocument = new byte[PredicateIndex.this.internalToExternalIdMapping.length];
            this.conjunctionIndexSearcher = PredicateIndex.this.conjunctionIndex.searcher();
        }

        public Stream<Hit> search(PredicateQuery query) {
            ArrayList<PostingList> postingLists = new ArrayList<PostingList>();
            for (PredicateQuery.Feature feature : query.getFeatures()) {
                this.addIntervalPostingList(feature.featureHash, feature.subqueryBitmap, postingLists);
            }
            for (PredicateQuery.RangeFeature rangeFeature : query.getRangeFeatures()) {
                PredicateIndex.this.expander.expand(rangeFeature.key, rangeFeature.value, featureHash -> this.addIntervalPostingList(featureHash, feature.subqueryBitmap, postingLists), (featureHash, value) -> this.addBoundsPostingList(featureHash, value, feature.subqueryBitmap, postingLists));
            }
            this.addCompressedZStarPostingList(postingLists);
            this.addConjunctionPostingLists(query, postingLists);
            this.addZeroConstraintPostingList(postingLists);
            CachedPostingListCounter counter = PredicateIndex.this.postingListCounter.get();
            counter.registerUsage(postingLists);
            counter.countPostingListsPerDocument(postingLists, this.nPostingListsForDocument);
            return new PredicateSearch(postingLists, this.nPostingListsForDocument, PredicateIndex.this.minFeatureIndex, PredicateIndex.this.intervalEnds, PredicateIndex.this.highestIntervalEnd).stream().map(hit -> new Hit(PredicateIndex.this.internalToExternalIdMapping[hit.getDocId()], hit.getSubquery()));
        }

        private void addCompressedZStarPostingList(List<PostingList> postingLists) {
            SimpleIndex.Entry e = PredicateIndex.this.intervalIndex.getPostingList(Feature.Z_STAR_COMPRESSED_ATTRIBUTE_HASH);
            if (e != null) {
                postingLists.add(new ZstarCompressedPostingList(PredicateIndex.this.intervalStore, e.docIds, e.dataRefs));
            }
        }

        private void addBoundsPostingList(long featureHash, int value, long subqueryBitMap, List<PostingList> postingLists) {
            SimpleIndex.Entry e = PredicateIndex.this.boundsIndex.getPostingList(featureHash);
            if (e != null) {
                postingLists.add(new BoundsPostingList(PredicateIndex.this.intervalStore, e.docIds, e.dataRefs, subqueryBitMap, value));
            }
        }

        private void addIntervalPostingList(long featureHash, long subqueryBitMap, List<PostingList> postingLists) {
            SimpleIndex.Entry e = PredicateIndex.this.intervalIndex.getPostingList(featureHash);
            if (e != null) {
                postingLists.add(new IntervalPostingList(PredicateIndex.this.intervalStore, e.docIds, e.dataRefs, subqueryBitMap));
            }
        }

        private void addConjunctionPostingLists(PredicateQuery query, List<PostingList> postingLists) {
            List<ConjunctionHit> hits = this.conjunctionIndexSearcher.search(query);
            for (ConjunctionHit hit : hits) {
                SimpleIndex.Entry e = PredicateIndex.this.conjunctionIntervalIndex.getPostingList(hit.conjunctionId);
                if (e == null) continue;
                postingLists.add(new IntervalPostingList(PredicateIndex.this.intervalStore, e.docIds, e.dataRefs, hit.subqueryBitmap));
            }
        }

        private void addZeroConstraintPostingList(ArrayList<PostingList> postingLists) {
            if (PredicateIndex.this.zeroConstraintDocuments.length > 0) {
                postingLists.add(new ZeroConstraintPostingList(PredicateIndex.this.zeroConstraintDocuments));
            }
        }
    }
}

