/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import com.yahoo.search.predicate.index.Interval;
import com.yahoo.search.predicate.index.MultiIntervalPostingList;
import com.yahoo.search.predicate.index.PredicateIntervalStore;

public class ZstarCompressedPostingList
extends MultiIntervalPostingList {
    private final PredicateIntervalStore store;
    private int[] currentIntervals;
    private int currentIntervalIndex;
    private int prevInterval;
    private int currentInterval;

    public ZstarCompressedPostingList(PredicateIntervalStore store, int[] docIds, int[] dataRefs) {
        super(docIds, dataRefs, -1L);
        this.store = store;
    }

    @Override
    protected boolean prepareIntervals(int dataRef) {
        this.currentIntervals = this.store.get(dataRef);
        this.currentIntervalIndex = 0;
        return this.nextInterval();
    }

    @Override
    public boolean nextInterval() {
        int nextInterval = -1;
        if (this.currentIntervalIndex < this.currentIntervals.length) {
            nextInterval = this.currentIntervals[this.currentIntervalIndex];
        }
        if (this.prevInterval != 0) {
            if (Interval.isZStar2Interval(nextInterval)) {
                this.currentInterval = Interval.combineZStarIntervals(this.prevInterval, nextInterval);
                ++this.currentIntervalIndex;
            } else {
                int end = Interval.getZStar1End(this.prevInterval);
                this.currentInterval = Interval.fromZStar1Boundaries(end, end + 1);
            }
            this.prevInterval = 0;
            return true;
        }
        if (nextInterval != -1) {
            this.currentInterval = nextInterval;
            ++this.currentIntervalIndex;
            this.prevInterval = nextInterval;
            return true;
        }
        return false;
    }

    @Override
    public int getInterval() {
        return this.currentInterval;
    }
}

