/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index.conjunction;

import com.yahoo.search.predicate.index.conjunction.ConjunctionId;

public class ConjunctionIdIterator {
    private final int[] conjunctionIds;
    private final long subqueryBitmap;
    private int currentConjunctionId;
    private int length;
    private int index;

    public ConjunctionIdIterator(long subqueryBitmap, int[] conjunctionIds) {
        this.subqueryBitmap = subqueryBitmap;
        this.conjunctionIds = conjunctionIds;
        this.currentConjunctionId = conjunctionIds[0];
        this.length = conjunctionIds.length;
        this.index = 0;
    }

    public boolean next(int conjunctionId) {
        if (this.index == this.length) {
            return false;
        }
        int candidate = this.currentConjunctionId;
        while (ConjunctionId.compare(conjunctionId, candidate) > 0 && ++this.index < this.length) {
            candidate = this.conjunctionIds[this.index];
        }
        this.currentConjunctionId = candidate;
        return ConjunctionId.compare(conjunctionId, candidate) <= 0;
    }

    public long getSubqueryBitmap() {
        return this.subqueryBitmap;
    }

    public int getConjunctionId() {
        return this.currentConjunctionId;
    }

    public int[] getConjunctionIds() {
        return this.conjunctionIds;
    }
}

