/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.utils;

public class PostingListSearch {
    public static final int LINEAR_SEARCH_THRESHOLD = 16;
    public static final int LINEAR_SEARCH_THRESHOLD_2 = 32;
    public static final int BINARY_SEARCH_THRESHOLD = 32768;

    public static int interpolationSearch(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int lowVal = a[low];
        if (key - lowVal < 32) {
            return PostingListSearch.linearSearch(a, low, toIndex, key);
        }
        int high = toIndex - 1;
        int diff = high - low;
        if (diff <= 32768) {
            return PostingListSearch.binarySearch(a, low, toIndex, key);
        }
        int highVal = a[high];
        do {
            if (key == lowVal) {
                return low + 1;
            }
            if (key >= highVal) {
                return high + 1;
            }
            int mean = (int)((long)diff * (long)(key - lowVal) / (long)(highVal - lowVal));
            int eps = diff >>> 4;
            int lowMid = low + Math.max(0, mean - eps);
            int highMid = low + Math.min(diff, mean + eps);
            assert (lowMid <= highMid);
            assert (lowMid >= low);
            assert (highMid <= high);
            if (a[lowMid] > key) {
                high = lowMid;
                highVal = a[lowMid];
            } else if (a[highMid] <= key) {
                low = highMid;
                lowVal = a[highMid];
            } else {
                low = lowMid;
                lowVal = a[lowMid];
                high = highMid;
                highVal = a[highMid];
            }
            assert (low <= high);
        } while ((diff = high - low) >= 32768);
        return PostingListSearch.binarySearch(a, low, high + 1, key);
    }

    private static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        assert (fromIndex < toIndex);
        int low = fromIndex;
        int high = toIndex - 1;
        while (high - low > 16) {
            int mid = low + high >>> 1;
            assert (mid < high);
            if (a[mid] < key) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return PostingListSearch.linearSearch(a, low, high + 1, key);
    }

    private static int linearSearch(int[] a, int low, int high, int key) {
        assert (low < high);
        while (low < high && a[low] <= key) {
            ++low;
        }
        return low;
    }
}

