/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import com.yahoo.document.predicate.PredicateHash;

public class PredicateRangeTermExpander {
    private final int arity;
    private final int maxPositiveLevels;
    private final int maxNegativeLevels;
    private final long lowerBound;
    private final long upperBound;

    public PredicateRangeTermExpander(int arity) {
        this(arity, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PredicateRangeTermExpander(int arity, long lowerBound, long upperBound) {
        this.arity = arity;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.maxPositiveLevels = this.calculateMaxLevels(upperBound);
        this.maxNegativeLevels = this.calculateMaxLevels(-lowerBound);
    }

    private int calculateMaxLevels(long t) {
        int maxLevels = 1;
        while ((t /= (long)this.arity) != 0L) {
            ++maxLevels;
        }
        return maxLevels;
    }

    public void expand(String key, long value, RangeHandler rangeHandler, EdgeHandler edgeHandler) {
        long start;
        if (value < this.lowerBound || value > this.upperBound) {
            return;
        }
        int maxLevels = value > 0L ? this.maxPositiveLevels : this.maxNegativeLevels;
        int sign = value > 0L ? 1 : -1;
        StringBuilder builder = new StringBuilder(128);
        builder.append(key).append('=');
        long levelSize = this.arity;
        long edgeInterval = value / (long)this.arity * (long)this.arity;
        edgeHandler.handleEdge(this.createEdgeFeatureHash(builder, edgeInterval), (int)Math.abs(value - edgeInterval));
        for (int i = 0; i < maxLevels && Math.abs(start = value / levelSize * levelSize) + levelSize - 1L >= 0L; ++i) {
            rangeHandler.handleRange(this.createRangeFeatureHash(builder, start, start + (long)sign * (levelSize - 1L)));
            if ((levelSize *= (long)this.arity) <= 0L && levelSize != Long.MIN_VALUE) break;
        }
    }

    private long createRangeFeatureHash(StringBuilder builder, long start, long end) {
        int prefixLength = builder.length();
        String feature = end > 0L ? builder.append(start).append('-').append(end).toString() : builder.append(end).append('-').append(Math.abs(start)).toString();
        builder.setLength(prefixLength);
        return PredicateHash.hash64((String)feature);
    }

    private long createEdgeFeatureHash(StringBuilder builder, long edgeInterval) {
        int prefixLength = builder.length();
        String feature = builder.append(edgeInterval).toString();
        builder.setLength(prefixLength);
        return PredicateHash.hash64((String)feature);
    }

    @FunctionalInterface
    public static interface EdgeHandler {
        public void handleEdge(long var1, int var3);
    }

    @FunctionalInterface
    public static interface RangeHandler {
        public void handleRange(long var1);
    }
}

