/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate;

import com.yahoo.api.annotations.Beta;
import java.util.ArrayList;
import java.util.List;

@Beta
public class PredicateQuery {
    private final ArrayList<Feature> features = new ArrayList();
    private final ArrayList<RangeFeature> rangeFeatures = new ArrayList();

    public void addFeature(String key, String value) {
        this.addFeature(key, value, -1L);
    }

    public void addFeature(String key, String value, long subqueryBitMap) {
        this.features.add(new Feature(key, value, subqueryBitMap));
    }

    public void addRangeFeature(String key, long value) {
        this.addRangeFeature(key, value, -1L);
    }

    public void addRangeFeature(String key, long value, long subqueryBitMap) {
        this.rangeFeatures.add(new RangeFeature(key, value, subqueryBitMap));
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<RangeFeature> getRangeFeatures() {
        return this.rangeFeatures;
    }

    public static class RangeFeature {
        public final String key;
        public final long value;
        public final long subqueryBitmap;

        public RangeFeature(String key, long value, long subqueryBitmap) {
            this.key = key;
            this.value = value;
            this.subqueryBitmap = subqueryBitmap;
        }
    }

    public static class Feature {
        public final String key;
        public final String value;
        public final long subqueryBitmap;
        public final long featureHash;

        public Feature(String key, String value, long subqueryBitmap) {
            this.featureHash = com.yahoo.search.predicate.index.Feature.createHash(key, value);
            this.subqueryBitmap = subqueryBitmap;
            this.value = value;
            this.key = key;
        }
    }
}

