/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.utils;

import com.google.common.net.UrlEscapers;
import com.yahoo.search.predicate.PredicateQuery;
import com.yahoo.search.predicate.serialization.PredicateQuerySerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TargetingQueryFileConverter {
    private static final int MAX_NUMBER_OF_TERMS = 100;

    private TargetingQueryFileConverter() {
    }

    public static void main(String[] args) throws IOException {
        int nQueries = 123042;
        int batchFactor = 64;
        Subqueries subqueries = TargetingQueryFileConverter.parseRiseQueries(new File("test-data/rise-query2.txt"), nQueries);
        TargetingQueryFileConverter.filterOutHugeSubqueries(subqueries);
        List<Query> queries = TargetingQueryFileConverter.batchSubqueries(subqueries, batchFactor);
        TargetingQueryFileConverter.writeSubqueriesToFile(queries, new File("test-data/targeting-queries-json-" + batchFactor + "b-" + nQueries + "n.txt"), OutputFormat.JSON);
        TargetingQueryFileConverter.writeSubqueriesToFile(queries, new File("test-data/targeting-queries-yql-" + batchFactor + "b-" + nQueries + "n.txt"), OutputFormat.YQL);
    }

    private static void writeSubqueriesToFile(List<Query> queries, File output, OutputFormat outputFormat) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(output));){
            if (outputFormat == OutputFormat.JSON) {
                TargetingQueryFileConverter.writeJSONOutput(writer, queries);
            } else {
                TargetingQueryFileConverter.writeYQLOutput(writer, queries);
            }
        }
    }

    private static void writeJSONOutput(BufferedWriter writer, List<Query> queries) throws IOException {
        PredicateQuerySerializer serializer = new PredicateQuerySerializer();
        for (Query query : queries) {
            PredicateQuery predicateQuery = TargetingQueryFileConverter.toPredicateQuery(query);
            String json = serializer.toJSON(predicateQuery);
            writer.append(json).append('\n');
        }
    }

    private static PredicateQuery toPredicateQuery(Query query) {
        PredicateQuery predicateQuery = new PredicateQuery();
        for (Map.Entry<Long, Set<Feature>> e : query.valuesForSubqueries.entrySet()) {
            e.getValue().forEach(f -> predicateQuery.addFeature(f.key, f.strValue, (Long)e.getKey()));
        }
        for (Map.Entry<Long, Set<Feature>> e : query.rangesForSubqueries.entrySet()) {
            e.getValue().forEach(f -> predicateQuery.addRangeFeature(f.key, f.longValue, (Long)e.getKey()));
        }
        return predicateQuery;
    }

    private static void writeYQLOutput(BufferedWriter writer, List<Query> queries) throws IOException {
        for (Query query : queries) {
            writer.append(TargetingQueryFileConverter.toYqlString(query)).append('\n');
        }
    }

    private static String toYqlString(Query query) {
        StringBuilder yqlBuilder = new StringBuilder("select * from sources * where predicate(boolean, ");
        yqlBuilder.append(TargetingQueryFileConverter.createYqlFormatSubqueryMapString(query.valuesForSubqueries, query.isSingleQuery)).append(", ").append(TargetingQueryFileConverter.createYqlFormatSubqueryMapString(query.rangesForSubqueries, query.isSingleQuery)).append(");");
        return "/search/?query&nocache&yql=" + UrlEscapers.urlFormParameterEscaper().escape(yqlBuilder.toString());
    }

    private static List<Query> batchSubqueries(Subqueries subqueries, int subqueryBatchFactor) {
        Iterator<Integer> iterator = subqueries.subqueries.iterator();
        ArrayList<Query> result = new ArrayList<Query>();
        while (iterator.hasNext()) {
            TreeMap<Feature, Long> subqueriesForValue = new TreeMap<Feature, Long>();
            TreeMap<Feature, Long> subqueriesForRange = new TreeMap<Feature, Long>();
            for (int i = 0; i < Math.max(1, subqueryBatchFactor) && iterator.hasNext(); ++i) {
                Integer subquery = iterator.next();
                TargetingQueryFileConverter.registerSubqueryValues(i, subqueries.valuesForSubquery.get(subquery), subqueriesForValue);
                TargetingQueryFileConverter.registerSubqueryValues(i, subqueries.rangesForSubquery.get(subquery), subqueriesForRange);
            }
            Query query = new Query(subqueryBatchFactor == 0);
            TargetingQueryFileConverter.simplifyAndFillQueryValues(query.valuesForSubqueries, subqueriesForValue);
            TargetingQueryFileConverter.simplifyAndFillQueryValues(query.rangesForSubqueries, subqueriesForRange);
            result.add(query);
        }
        return result;
    }

    private static void registerSubqueryValues(int subquery, Set<Feature> values, Map<Feature, Long> subqueriesForValue) {
        if (values != null) {
            values.forEach(value -> subqueriesForValue.merge((Feature)value, 1L << subquery, (ids1, ids2) -> ids1 | ids2));
        }
    }

    private static void simplifyAndFillQueryValues(Map<Long, Set<Feature>> queryValues, Map<Feature, Long> subqueriesForValue) {
        for (Map.Entry<Feature, Long> entry : subqueriesForValue.entrySet()) {
            Feature feature = entry.getKey();
            Long subqueryBitmap = entry.getValue();
            Set featureSet = queryValues.computeIfAbsent(subqueryBitmap, k -> new HashSet());
            featureSet.add(feature);
        }
    }

    private static String createYqlFormatSubqueryMapString(Map<Long, Set<Feature>> subqueriesForString, boolean isSingleQuery) {
        return subqueriesForString.entrySet().stream().map(e -> {
            Stream<String> features = ((Set)e.getValue()).stream().map(Feature::asYqlString);
            if (isSingleQuery) {
                return features.collect(Collectors.joining(", "));
            }
            String values = features.collect(Collectors.joining(", ", "{", "}"));
            return String.format("\"0x%s\":%s", Long.toHexString((Long)e.getKey()), values);
        }).collect(Collectors.joining(", ", "{", "}"));
    }

    private static Subqueries parseRiseQueries(File riseQueryFile, int maxQueries) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(riseQueryFile));){
            Subqueries parsedSubqueries = new Subqueries();
            AtomicInteger counter = new AtomicInteger(1);
            reader.lines().limit(maxQueries).forEach(riseQuery -> TargetingQueryFileConverter.parseRiseQuery(parsedSubqueries, riseQuery, counter.getAndIncrement()));
            Subqueries subqueries = parsedSubqueries;
            return subqueries;
        }
    }

    private static void filterOutHugeSubqueries(Subqueries subqueries) {
        Iterator<Integer> iterator = subqueries.subqueries.iterator();
        while (iterator.hasNext()) {
            Set<Feature> ranges;
            int sizeRanges;
            Integer subquery = iterator.next();
            Set<Feature> values = subqueries.valuesForSubquery.get(subquery);
            int sizeValues = values == null ? 0 : values.size();
            if (sizeValues + (sizeRanges = (ranges = subqueries.rangesForSubquery.get(subquery)) == null ? 0 : ranges.size()) <= 100) continue;
            iterator.remove();
            subqueries.valuesForSubquery.remove(subquery);
            subqueries.rangesForSubquery.remove(subquery);
        }
    }

    private static void parseRiseQuery(Subqueries subqueries, String queryString, int queryId) {
        StringTokenizer subQueryTokenizer = new StringTokenizer(queryString, "\t", true);
        while (subQueryTokenizer.hasMoreTokens()) {
            String key = subQueryTokenizer.nextToken("\t");
            subQueryTokenizer.nextToken();
            String value = subQueryTokenizer.nextToken();
            if (value.equals("\t")) {
                value = "";
            } else {
                subQueryTokenizer.nextToken();
            }
            int subQueryIndex = Integer.parseInt(subQueryTokenizer.nextToken());
            subQueryTokenizer.nextToken();
            boolean isRangeTerm = Boolean.parseBoolean(subQueryTokenizer.nextToken(";"));
            if (subQueryTokenizer.hasMoreTokens()) {
                subQueryTokenizer.nextToken();
            }
            int subqueryId = subQueryIndex + 64 * queryId;
            if (isRangeTerm) {
                Set rangeFeatures = subqueries.rangesForSubquery.computeIfAbsent(subqueryId, id -> new HashSet());
                rangeFeatures.add(new Feature(key, Long.parseLong(value)));
            } else {
                Set features = subqueries.valuesForSubquery.computeIfAbsent(subqueryId, id -> new HashSet());
                features.add(new Feature(key, value));
            }
            subqueries.subqueries.add(subqueryId);
        }
    }

    private static class Feature
    implements Comparable<Feature> {
        public final String key;
        private final String strValue;
        private final long longValue;

        public Feature(String key, String value) {
            this.key = key;
            this.strValue = value;
            this.longValue = 0L;
        }

        public Feature(String key, long value) {
            this.key = key;
            this.strValue = null;
            this.longValue = value;
        }

        public String asYqlString() {
            if (this.strValue != null) {
                return String.format("\"%s\":\"%s\"", this.key, this.strValue);
            }
            return String.format("\"%s\":%dl", this.key, this.longValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Feature)) {
                return false;
            }
            Feature feature = (Feature)o;
            if (this.longValue != feature.longValue) {
                return false;
            }
            if (!this.key.equals(feature.key)) {
                return false;
            }
            return !(this.strValue == null ? feature.strValue != null : !this.strValue.equals(feature.strValue));
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.strValue != null ? this.strValue.hashCode() : 0);
            result = 31 * result + (int)(this.longValue ^ this.longValue >>> 32);
            return result;
        }

        @Override
        public int compareTo(Feature o) {
            return this.asYqlString().compareTo(o.asYqlString());
        }
    }

    private static class Query {
        public final boolean isSingleQuery;
        public final Map<Long, Set<Feature>> valuesForSubqueries = new TreeMap<Long, Set<Feature>>();
        public final Map<Long, Set<Feature>> rangesForSubqueries = new TreeMap<Long, Set<Feature>>();

        public Query(boolean isSingleQuery) {
            this.isSingleQuery = isSingleQuery;
        }
    }

    private static class Subqueries {
        public final TreeSet<Integer> subqueries = new TreeSet();
        public final Map<Integer, Set<Feature>> valuesForSubquery = new HashMap<Integer, Set<Feature>>();
        public final Map<Integer, Set<Feature>> rangesForSubquery = new HashMap<Integer, Set<Feature>>();

        private Subqueries() {
        }
    }

    private static enum OutputFormat {
        JSON,
        YQL;

    }
}

