/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index.conjunction;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.gs.collections.api.map.primitive.IntObjectMap;
import com.gs.collections.api.map.primitive.LongObjectMap;
import com.gs.collections.impl.map.mutable.primitive.IntObjectHashMap;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import com.yahoo.search.predicate.index.conjunction.ConjunctionIndex;
import com.yahoo.search.predicate.index.conjunction.IndexableFeatureConjunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ConjunctionIndexBuilder {
    private final HashMap<Integer, FeatureIndexBuilder> kIndexBuilder = new HashMap();
    private final List<Integer> zListBuilder = new ArrayList<Integer>();
    private final Set<Long> seenIds = new LinkedHashSet<Long>();
    private int idCounter = 0;
    private int conjunctionsSeen = 0;

    public void indexConjunction(IndexableFeatureConjunction c) {
        ++this.conjunctionsSeen;
        long externalId = c.id;
        if (this.seenIds.contains(externalId)) {
            return;
        }
        this.seenIds.add(externalId);
        int internalId = this.generateInternalId();
        FeatureIndexBuilder featureIndexBuilder = this.kIndexBuilder.computeIfAbsent(c.k, k -> new FeatureIndexBuilder());
        c.features.forEach(f -> featureIndexBuilder.insert((long)f, internalId));
        c.negatedFeatures.forEach(f -> featureIndexBuilder.insert((long)f, internalId & 0xFFFFFFFE));
        if (c.k == 0) {
            this.zListBuilder.add(internalId);
        }
    }

    private int generateInternalId() {
        return this.idCounter++ << 1 | 1;
    }

    public ConjunctionIndex build() {
        int[] zList = Ints.toArray(this.zListBuilder);
        IntObjectMap<ConjunctionIndex.FeatureIndex> kIndex = ConjunctionIndexBuilder.buildKIndex(this.kIndexBuilder);
        long[] idMapping = Longs.toArray(this.seenIds);
        return new ConjunctionIndex(kIndex, zList, idMapping);
    }

    public long calculateFeatureCount() {
        return this.kIndexBuilder.values().stream().map(index -> index.map.keySet()).reduce(new HashSet(), (acc, keySet) -> {
            keySet.forEach(acc::add);
            return acc;
        }, (acc1, acc2) -> {
            acc1.addAll(acc2);
            return acc1;
        }).size();
    }

    public long getUniqueConjunctionCount() {
        return this.seenIds.size();
    }

    public int getZListSize() {
        return this.zListBuilder.size();
    }

    public int getConjunctionsSeen() {
        return this.conjunctionsSeen;
    }

    private static IntObjectMap<ConjunctionIndex.FeatureIndex> buildKIndex(HashMap<Integer, FeatureIndexBuilder> kIndexBuilder) {
        IntObjectHashMap map = new IntObjectHashMap();
        for (Map.Entry<Integer, FeatureIndexBuilder> entry : kIndexBuilder.entrySet()) {
            map.put(entry.getKey().intValue(), (Object)ConjunctionIndexBuilder.buildFeatureIndex(entry.getValue()));
        }
        map.compact();
        return map;
    }

    private static ConjunctionIndex.FeatureIndex buildFeatureIndex(FeatureIndexBuilder featureIndexBuilder) {
        LongObjectHashMap map = new LongObjectHashMap();
        for (Map.Entry<Long, Set<Integer>> featureEntry : featureIndexBuilder.map.entrySet()) {
            int[] conjunctionIds = Ints.toArray((Collection)featureEntry.getValue());
            map.put(featureEntry.getKey().longValue(), (Object)conjunctionIds);
        }
        map.compact();
        return new ConjunctionIndex.FeatureIndex((LongObjectMap<int[]>)map);
    }

    private static class FeatureIndexBuilder {
        private final Map<Long, Set<Integer>> map = new HashMap<Long, Set<Integer>>();

        private FeatureIndexBuilder() {
        }

        public void insert(long featureId, int conjunctionId) {
            this.map.computeIfAbsent(featureId, k -> new TreeSet()).add(conjunctionId);
        }
    }
}

