/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import com.google.common.primitives.Ints;
import com.yahoo.search.predicate.serialization.SerializationHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PredicateIntervalStore {
    private final int[][] intervalsList;

    public PredicateIntervalStore(int[][] intervalsList) {
        this.intervalsList = intervalsList;
    }

    public int[] get(int intervalRef) {
        assert (intervalRef < this.intervalsList.length);
        return this.intervalsList[intervalRef];
    }

    public void writeToOutputStream(DataOutputStream out) throws IOException {
        out.writeInt(this.intervalsList.length);
        for (int[] intervals : this.intervalsList) {
            SerializationHelper.writeIntArray(intervals, out);
        }
    }

    public static PredicateIntervalStore fromInputStream(DataInputStream in) throws IOException {
        int length = in.readInt();
        int[][] intervalsList = new int[length][];
        for (int i = 0; i < length; ++i) {
            intervalsList[i] = SerializationHelper.readIntArray(in);
        }
        return new PredicateIntervalStore(intervalsList);
    }

    public static class Builder {
        private final List<int[]> intervalsListBuilder = new ArrayList<int[]>();
        private final Map<Entry, Integer> intervalsListIndexes = new HashMap<Entry, Integer>();
        private final Map<Integer, Integer> entriesForSize = new HashMap<Integer, Integer>();
        private int cacheHits = 0;
        private int totalInserts = 0;

        public int insert(List<Integer> intervals) {
            int size = intervals.size();
            if (size == 0) {
                throw new IllegalArgumentException("Cannot insert interval list of size 0");
            }
            int[] array = Ints.toArray(intervals);
            Entry entry = new Entry(array);
            ++this.totalInserts;
            if (this.intervalsListIndexes.containsKey(entry)) {
                ++this.cacheHits;
                return this.intervalsListIndexes.get(entry);
            }
            int index = this.intervalsListBuilder.size();
            this.intervalsListBuilder.add(array);
            this.intervalsListIndexes.put(entry, index);
            this.entriesForSize.merge(size, 1, Integer::sum);
            return index;
        }

        public PredicateIntervalStore build() {
            int nIntervals = this.intervalsListBuilder.size();
            int[][] intervalsList = new int[nIntervals][];
            for (int i = 0; i < nIntervals; ++i) {
                intervalsList[i] = this.intervalsListBuilder.get(i);
            }
            return new PredicateIntervalStore(intervalsList);
        }

        public int getCacheHits() {
            return this.cacheHits;
        }

        public int getTotalInserts() {
            return this.totalInserts;
        }

        public Map<Integer, Integer> getEntriesForSize() {
            return this.entriesForSize;
        }

        public int getNumberOfIntervals() {
            return this.intervalsListBuilder.size();
        }

        private static class Entry {
            public final int[] intervals;
            public final int hashCode;

            public Entry(int[] intervals) {
                this.intervals = intervals;
                this.hashCode = Arrays.hashCode(intervals);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entry entry = (Entry)o;
                return Arrays.equals(this.intervals, entry.intervals);
            }

            public int hashCode() {
                return this.hashCode;
            }
        }
    }
}

