/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.utils;

public class PrimitiveArraySorter {
    private PrimitiveArraySorter() {
    }

    public static void sort(short[] array, ShortComparator comparator) {
        PrimitiveArraySorter.sort(array, 0, array.length, comparator);
    }

    public static void sort(short[] array, int fromIndex, int toIndex, ShortComparator comparator) {
        if (toIndex - fromIndex <= 20) {
            PrimitiveArraySorter.insertionSort(array, fromIndex, toIndex, comparator);
            return;
        }
        int i = fromIndex;
        int j = toIndex - 1;
        short pivotValue = array[i + (j - i) / 2];
        while (i < j) {
            while (comparator.compare(pivotValue, array[i]) > 0) {
                ++i;
            }
            while (comparator.compare(array[j], pivotValue) > 0) {
                --j;
            }
            if (i >= j) continue;
            short temp = array[i];
            array[i] = array[j];
            array[j] = temp;
            ++i;
            --j;
        }
        if (fromIndex < j) {
            PrimitiveArraySorter.sort(array, fromIndex, j + 1, comparator);
        }
        if (i < toIndex - 1) {
            PrimitiveArraySorter.sort(array, i, toIndex, comparator);
        }
    }

    public static boolean sortAndMerge(short[] array, short[] mergeArray, int pivotIndex, int toIndex, ShortComparator comparator) {
        if (array.length == 1) {
            return false;
        }
        PrimitiveArraySorter.sort(array, 0, pivotIndex, comparator);
        if (pivotIndex == toIndex || comparator.compare(array[pivotIndex - 1], array[pivotIndex]) <= 0) {
            return false;
        }
        PrimitiveArraySorter.merge(array, mergeArray, pivotIndex, toIndex, comparator);
        return true;
    }

    public static void merge(short[] array, short[] mergeArray, int pivotIndex, ShortComparator comparator) {
        PrimitiveArraySorter.merge(array, mergeArray, pivotIndex, array.length, comparator);
    }

    public static void merge(short[] array, short[] mergeArray, int pivotIndex, int toIndex, ShortComparator comparator) {
        int indexMergeArray = 0;
        int indexPartition0 = 0;
        int indexPartition1 = pivotIndex;
        while (indexPartition0 < pivotIndex && indexPartition1 < toIndex) {
            short val0 = array[indexPartition0];
            short val1 = array[indexPartition1];
            if (comparator.compare(val0, val1) <= 0) {
                mergeArray[indexMergeArray++] = val0;
                ++indexPartition0;
                continue;
            }
            mergeArray[indexMergeArray++] = val1;
            ++indexPartition1;
        }
        int nLeftPartition0 = pivotIndex - indexPartition0;
        System.arraycopy(array, indexPartition0, mergeArray, indexMergeArray, nLeftPartition0);
        System.arraycopy(array, indexPartition1, mergeArray, indexMergeArray + nLeftPartition0, toIndex - indexPartition1);
    }

    private static void insertionSort(short[] array, int fromIndex, int toIndex, ShortComparator comparator) {
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            for (int j = i; j > 0 && comparator.compare(array[j - 1], array[j]) > 0; --j) {
                short temp = array[j - 1];
                array[j - 1] = array[j];
                array[j] = temp;
            }
        }
    }

    @FunctionalInterface
    public static interface ShortComparator {
        public int compare(short var1, short var2);
    }
}

