/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import com.yahoo.search.predicate.index.Interval;
import com.yahoo.search.predicate.index.PostingList;

public class ZeroConstraintPostingList
implements PostingList {
    private final int[] docIds;
    private final int length;
    private int currentIndex;
    private int currentDocId;

    public ZeroConstraintPostingList(int[] docIds) {
        this.docIds = docIds;
        this.currentIndex = 0;
        this.currentDocId = -1;
        this.length = docIds.length;
    }

    @Override
    public boolean nextDocument(int docId) {
        int currentDocId = this.currentDocId;
        while (this.currentIndex < this.length && currentDocId <= docId) {
            currentDocId = this.docIds[this.currentIndex++];
        }
        if (currentDocId <= docId) {
            return false;
        }
        this.currentDocId = currentDocId;
        return true;
    }

    @Override
    public boolean prepareIntervals() {
        return true;
    }

    @Override
    public boolean nextInterval() {
        return false;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public int getInterval() {
        return Interval.fromBoundaries(1, 1);
    }

    @Override
    public int getDocId() {
        return this.currentDocId;
    }

    @Override
    public long getSubquery() {
        return -1L;
    }

    @Override
    public int[] getDocIds() {
        return this.docIds;
    }
}

