/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.yahoo.document.predicate.BooleanPredicate;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.search.predicate.Config;
import com.yahoo.search.predicate.PredicateIndex;
import com.yahoo.search.predicate.annotator.PredicateTreeAnnotations;
import com.yahoo.search.predicate.annotator.PredicateTreeAnnotator;
import com.yahoo.search.predicate.index.Feature;
import com.yahoo.search.predicate.index.IntervalWithBounds;
import com.yahoo.search.predicate.index.Posting;
import com.yahoo.search.predicate.index.PredicateIntervalStore;
import com.yahoo.search.predicate.index.PredicateOptimizer;
import com.yahoo.search.predicate.index.SimpleIndex;
import com.yahoo.search.predicate.index.conjunction.ConjunctionIndexBuilder;
import com.yahoo.search.predicate.index.conjunction.IndexableFeatureConjunction;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

@Beta
public class PredicateIndexBuilder {
    private final Set<Integer> seenIds = new LinkedHashSet<Integer>();
    private final List<Short> intervalEndsBuilder = new ArrayList<Short>();
    private final List<Byte> minFeatureIndexBuilder = new ArrayList<Byte>();
    private final List<Integer> zeroConstraintDocuments = new ArrayList<Integer>();
    private final SimpleIndex.Builder intervalIndexBuilder = new SimpleIndex.Builder();
    private final SimpleIndex.Builder boundsIndexBuilder = new SimpleIndex.Builder();
    private final SimpleIndex.Builder conjunctionIntervalIndexBuilder = new SimpleIndex.Builder();
    private final ConjunctionIndexBuilder conjunctionIndexBuilder = new ConjunctionIndexBuilder();
    private final PredicateIntervalStore.Builder intervalStoreBuilder;
    private final PredicateOptimizer optimizer;
    private final Config config;
    private int documentIdCounter = 0;
    private int nZStarDocuments = 0;
    private int nZStarIntervals = 0;
    private int highestIntervalEnd = 1;

    public PredicateIndexBuilder(int arity) {
        this(new Config.Builder().setArity(arity).build());
    }

    public PredicateIndexBuilder(int arity, long lowerBound, long upperBound) {
        this(new Config.Builder().setArity(arity).setLowerBound(lowerBound).setUpperBound(upperBound).build());
    }

    public PredicateIndexBuilder(Config config) {
        this.config = config;
        this.optimizer = new PredicateOptimizer(config);
        this.intervalStoreBuilder = new PredicateIntervalStore.Builder();
    }

    public void indexDocument(int docId, Predicate predicate) {
        if (this.documentIdCounter == Integer.MAX_VALUE) {
            throw new IllegalStateException("Index is full, max number of documents is: 2147483647");
        }
        if (this.seenIds.contains(docId)) {
            throw new IllegalArgumentException("Document id is already in use: " + docId);
        }
        if (PredicateIndexBuilder.isNeverMatchingDocument(predicate)) {
            return;
        }
        this.seenIds.add(docId);
        predicate = this.optimizer.optimizePredicate(predicate);
        int internalId = this.documentIdCounter++;
        if (PredicateIndexBuilder.isAlwaysMatchingDocument(predicate)) {
            this.indexZeroConstraintDocument(internalId);
        } else {
            this.indexDocument(internalId, PredicateTreeAnnotator.createPredicateTreeAnnotations(predicate));
        }
    }

    private static boolean isAlwaysMatchingDocument(Predicate p) {
        return p instanceof BooleanPredicate && ((BooleanPredicate)p).getValue();
    }

    private static boolean isNeverMatchingDocument(Predicate p) {
        return p instanceof BooleanPredicate && !((BooleanPredicate)p).getValue();
    }

    private void indexZeroConstraintDocument(int docId) {
        this.minFeatureIndexBuilder.add((byte)0);
        this.intervalEndsBuilder.add((short)1);
        this.zeroConstraintDocuments.add(docId);
    }

    private void indexDocument(int docId, PredicateTreeAnnotations annotations) {
        int minFeature = annotations.minFeature;
        Preconditions.checkState((minFeature <= 255 ? 1 : 0) != 0, (String)"Predicate is too complex. Expected min-feature less than %d, was %d.", (int)255, (int)minFeature);
        int intervalEnd = annotations.intervalEnd;
        Preconditions.checkState((intervalEnd <= 65535 ? 1 : 0) != 0, (String)"Predicate is too complex. Expected min-feature less than %d, was %d.", (int)65535, (int)intervalEnd);
        this.highestIntervalEnd = Math.max(this.highestIntervalEnd, intervalEnd);
        this.intervalEndsBuilder.add((short)intervalEnd);
        this.minFeatureIndexBuilder.add((byte)minFeature);
        this.indexDocumentFeatures(docId, annotations.intervalMap);
        this.indexDocumentBoundsFeatures(docId, annotations.boundsMap);
        this.indexDocumentConjunctions(docId, annotations.featureConjunctions);
        this.aggregateZStarStatistics(annotations.intervalMap);
    }

    private void aggregateZStarStatistics(Map<Long, List<Integer>> intervalMap) {
        List<Integer> intervals = intervalMap.get(Feature.Z_STAR_COMPRESSED_ATTRIBUTE_HASH);
        if (intervals != null) {
            ++this.nZStarDocuments;
            this.nZStarIntervals += intervals.size();
        }
    }

    private void indexDocumentFeatures(int docId, Map<Long, List<Integer>> intervalMap) {
        intervalMap.entrySet().stream().forEach(entry -> this.intervalIndexBuilder.insert((Long)entry.getKey(), new Posting(docId, this.intervalStoreBuilder.insert((List)entry.getValue()))));
    }

    private void indexDocumentBoundsFeatures(int docId, Map<Long, List<IntervalWithBounds>> boundsMap) {
        boundsMap.entrySet().stream().forEach(entry -> this.boundsIndexBuilder.insert((Long)entry.getKey(), new Posting(docId, this.intervalStoreBuilder.insert(((List)entry.getValue()).stream().flatMap(IntervalWithBounds::stream).collect(Collectors.toList())))));
    }

    private void indexDocumentConjunctions(int docId, Map<IndexableFeatureConjunction, List<Integer>> featureConjunctions) {
        for (Map.Entry<IndexableFeatureConjunction, List<Integer>> e : featureConjunctions.entrySet()) {
            IndexableFeatureConjunction fc = e.getKey();
            List<Integer> intervals = e.getValue();
            Posting posting = new Posting(docId, this.intervalStoreBuilder.insert(intervals));
            this.conjunctionIntervalIndexBuilder.insert(fc.id, posting);
            this.conjunctionIndexBuilder.indexConjunction(fc);
        }
    }

    public PredicateIndex build() {
        return new PredicateIndex(this.config, Ints.toArray(this.seenIds), Bytes.toArray(this.minFeatureIndexBuilder), Shorts.toArray(this.intervalEndsBuilder), this.highestIntervalEnd, this.intervalIndexBuilder.build(), this.boundsIndexBuilder.build(), this.conjunctionIntervalIndexBuilder.build(), this.intervalStoreBuilder.build(), this.conjunctionIndexBuilder.build(), Ints.toArray(this.zeroConstraintDocuments));
    }

    public int getZeroConstraintDocCount() {
        return this.zeroConstraintDocuments.size();
    }

    public PredicateIndexStats getStats() {
        return new PredicateIndexStats(this.zeroConstraintDocuments, this.intervalIndexBuilder, this.boundsIndexBuilder, this.intervalStoreBuilder, this.conjunctionIndexBuilder, this.nZStarDocuments, this.nZStarIntervals);
    }

    public static class PredicateIndexStats {
        private final Map<String, Object> metrics = new TreeMap<String, Object>();

        public PredicateIndexStats(List<Integer> zeroConstraintDocuments, SimpleIndex.Builder intervalIndex, SimpleIndex.Builder boundsIndex, PredicateIntervalStore.Builder intervalStore, ConjunctionIndexBuilder conjunctionIndex, int nZStarDocuments, int nZStarIntervals) {
            Map<Integer, Integer> intervalStoreEntries = intervalStore.getEntriesForSize();
            this.metrics.put("Zero-constraint documents", zeroConstraintDocuments.size());
            this.metrics.put("Interval index keys", intervalIndex.getKeyCount());
            this.metrics.put("Interval index entries", intervalIndex.getEntryCount());
            this.metrics.put("Bounds index keys", boundsIndex.getKeyCount());
            this.metrics.put("Bounds index entries", boundsIndex.getEntryCount());
            this.metrics.put("Conjunction index feature count", conjunctionIndex.calculateFeatureCount());
            this.metrics.put("Conjunction index unique conjunction count", conjunctionIndex.getUniqueConjunctionCount());
            this.metrics.put("Conjunction index conjunction count", conjunctionIndex.getConjunctionsSeen());
            this.metrics.put("Conjunction index Z list size", conjunctionIndex.getZListSize());
            this.metrics.put("Interval store cache hits", intervalStore.getCacheHits());
            this.metrics.put("Interval store insert count", intervalStore.getTotalInserts());
            this.metrics.put("Interval store interval count", intervalStore.getNumberOfIntervals());
            this.metrics.put("Documents with ZStar intervals", nZStarDocuments);
            this.metrics.put("Total ZStar intervals", nZStarIntervals);
            intervalStoreEntries.entrySet().stream().filter(entry -> (Integer)entry.getKey() != 0).forEach(entry -> this.metrics.put("Size " + entry.getKey() + " intervals", entry.getValue()));
        }

        public void putValues(Map<String, Object> valueMap) {
            valueMap.putAll(this.metrics);
        }

        public String toString() {
            return this.metrics.entrySet().stream().map(e -> String.format("%50s: %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
        }
    }
}

