/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import com.yahoo.search.predicate.index.PostingList;
import com.yahoo.search.predicate.utils.PostingListSearch;

public abstract class MultiIntervalPostingList
implements PostingList {
    private final int[] docIds;
    private final int[] dataRefs;
    private final long subquery;
    private final int length;
    private int currentIndex;
    private int currentDocId;

    public MultiIntervalPostingList(int[] docIds, int[] dataRefs, long subquery) {
        this.docIds = docIds;
        this.dataRefs = dataRefs;
        this.subquery = subquery;
        this.length = docIds.length;
        this.currentIndex = 0;
        this.currentDocId = -1;
    }

    @Override
    public final boolean nextDocument(int docId) {
        int index = this.currentIndex;
        if ((index = PostingListSearch.interpolationSearch(this.docIds, index, this.length, docId)) == this.length) {
            return false;
        }
        this.currentDocId = this.docIds[index];
        this.currentIndex = index;
        assert (this.currentDocId > docId);
        return true;
    }

    @Override
    public final boolean prepareIntervals() {
        return this.prepareIntervals(this.dataRefs[this.currentIndex]);
    }

    protected abstract boolean prepareIntervals(int var1);

    @Override
    public final int size() {
        return this.length;
    }

    @Override
    public final int getDocId() {
        return this.currentDocId;
    }

    @Override
    public final int[] getDocIds() {
        return this.docIds;
    }

    @Override
    public final long getSubquery() {
        return this.subquery;
    }
}

