/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import com.gs.collections.api.map.primitive.LongObjectMap;
import com.gs.collections.api.tuple.primitive.LongObjectPair;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import com.yahoo.search.predicate.index.Posting;
import com.yahoo.search.predicate.serialization.SerializationHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleIndex {
    private final LongObjectMap<Entry> dictionary;

    public SimpleIndex(LongObjectMap<Entry> dictionary) {
        this.dictionary = dictionary;
    }

    public Entry getPostingList(long key) {
        return (Entry)this.dictionary.get(key);
    }

    public void writeToOutputStream(DataOutputStream out) throws IOException {
        out.writeInt(this.dictionary.size());
        for (LongObjectPair pair : this.dictionary.keyValuesView()) {
            out.writeLong(pair.getOne());
            Entry entry = (Entry)pair.getTwo();
            SerializationHelper.writeIntArray(entry.docIds, out);
            SerializationHelper.writeIntArray(entry.dataRefs, out);
        }
    }

    public static SimpleIndex fromInputStream(DataInputStream in) throws IOException {
        int nEntries = in.readInt();
        LongObjectHashMap dictionary = new LongObjectHashMap(nEntries);
        for (int i = 0; i < nEntries; ++i) {
            long key = in.readLong();
            int[] docIds = SerializationHelper.readIntArray(in);
            int[] dataRefs = SerializationHelper.readIntArray(in);
            dictionary.put(key, (Object)new Entry(docIds, dataRefs));
        }
        dictionary.compact();
        return new SimpleIndex((LongObjectMap<Entry>)dictionary);
    }

    public static class Builder {
        private final HashMap<Long, List<Posting>> dictionaryBuilder = new HashMap();
        private int entryCount;

        public void insert(long key, Posting posting) {
            this.dictionaryBuilder.computeIfAbsent(key, k -> new ArrayList()).add(posting);
            ++this.entryCount;
        }

        public SimpleIndex build() {
            LongObjectHashMap dictionary = new LongObjectHashMap();
            for (Map.Entry<Long, List<Posting>> entry : this.dictionaryBuilder.entrySet()) {
                List<Posting> postings = entry.getValue();
                Collections.sort(postings);
                int size = postings.size();
                int[] docIds = new int[size];
                int[] dataRefs = new int[size];
                for (int i = 0; i < size; ++i) {
                    Posting posting = postings.get(i);
                    docIds[i] = posting.getId();
                    dataRefs[i] = posting.getDataRef();
                }
                dictionary.put(entry.getKey().longValue(), (Object)new Entry(docIds, dataRefs));
            }
            dictionary.compact();
            return new SimpleIndex((LongObjectMap<Entry>)dictionary);
        }

        public int getEntryCount() {
            return this.entryCount;
        }

        public int getKeyCount() {
            return this.dictionaryBuilder.size();
        }
    }

    public static class Entry {
        public final int[] docIds;
        public final int[] dataRefs;

        private Entry(int[] docIds, int[] dataRefs) {
            this.docIds = docIds;
            this.dataRefs = dataRefs;
        }
    }
}

