/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index.conjunction;

import com.gs.collections.api.map.primitive.IntObjectMap;
import com.gs.collections.api.map.primitive.LongObjectMap;
import com.gs.collections.api.tuple.primitive.IntObjectPair;
import com.gs.collections.api.tuple.primitive.LongObjectPair;
import com.gs.collections.impl.map.mutable.primitive.IntObjectHashMap;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import com.yahoo.search.predicate.PredicateQuery;
import com.yahoo.search.predicate.index.conjunction.ConjunctionHit;
import com.yahoo.search.predicate.index.conjunction.ConjunctionId;
import com.yahoo.search.predicate.index.conjunction.ConjunctionIdIterator;
import com.yahoo.search.predicate.serialization.SerializationHelper;
import com.yahoo.search.predicate.utils.PrimitiveArraySorter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ConjunctionIndex {
    private final IntObjectMap<FeatureIndex> kIndex;
    private final int[] zList;
    private final long[] idMapping;

    public ConjunctionIndex(IntObjectMap<FeatureIndex> kIndex, int[] zList, long[] idMapping) {
        this.kIndex = kIndex;
        this.zList = zList;
        this.idMapping = idMapping;
    }

    public Searcher searcher() {
        return new Searcher();
    }

    public void writeToOutputStream(DataOutputStream out) throws IOException {
        SerializationHelper.writeIntArray(this.zList, out);
        SerializationHelper.writeLongArray(this.idMapping, out);
        out.writeInt(this.kIndex.size());
        for (IntObjectPair p : this.kIndex.keyValuesView()) {
            out.writeInt(p.getOne());
            ((FeatureIndex)p.getTwo()).writeToOutputStream(out);
        }
    }

    public static ConjunctionIndex fromInputStream(DataInputStream in) throws IOException {
        int[] zList = SerializationHelper.readIntArray(in);
        long[] idMapping = SerializationHelper.readLongArray(in);
        int kIndexSize = in.readInt();
        IntObjectHashMap kIndex = new IntObjectHashMap(kIndexSize);
        for (int i = 0; i < kIndexSize; ++i) {
            int key = in.readInt();
            kIndex.put(key, (Object)FeatureIndex.fromInputStream(in));
        }
        kIndex.compact();
        return new ConjunctionIndex((IntObjectMap<FeatureIndex>)kIndex, zList, idMapping);
    }

    public class Searcher {
        private final byte[] iteratorsPerConjunction;

        private Searcher() {
            this.iteratorsPerConjunction = new byte[ConjunctionIndex.this.idMapping.length];
        }

        public List<ConjunctionHit> search(PredicateQuery query) {
            int uniqueKeys;
            ArrayList<ConjunctionHit> conjunctionHits = new ArrayList<ConjunctionHit>();
            for (int k = uniqueKeys = (int)query.getFeatures().stream().map(e -> e.key).distinct().count(); k >= 0; --k) {
                ArrayList<ConjunctionIdIterator> iterators = new ArrayList<ConjunctionIdIterator>();
                this.getFeatureIndex(k).ifPresent(featureIndex -> this.addFeatureIterators(query, (FeatureIndex)featureIndex, (List<ConjunctionIdIterator>)iterators));
                if (k == 0 && ConjunctionIndex.this.zList.length > 0) {
                    iterators.add(new ConjunctionIdIterator(-1L, ConjunctionIndex.this.zList));
                }
                if (iterators.isEmpty()) continue;
                this.calculateIteratorsPerConjunction(iterators);
                this.findMatchingConjunctions(k, iterators, conjunctionHits, this.iteratorsPerConjunction);
            }
            return conjunctionHits;
        }

        private void calculateIteratorsPerConjunction(List<ConjunctionIdIterator> iterators) {
            Arrays.fill(this.iteratorsPerConjunction, (byte)0);
            for (ConjunctionIdIterator iterator : iterators) {
                for (int id : iterator.getConjunctionIds()) {
                    if (!ConjunctionId.isPositive(id)) continue;
                    int n = id >>> 1;
                    this.iteratorsPerConjunction[n] = (byte)(this.iteratorsPerConjunction[n] + 1);
                }
            }
        }

        private Optional<FeatureIndex> getFeatureIndex(int k) {
            return Optional.ofNullable(ConjunctionIndex.this.kIndex.get(k));
        }

        private void addFeatureIterators(PredicateQuery query, FeatureIndex featureIndex, List<ConjunctionIdIterator> iterators) {
            query.getFeatures().stream().map(e -> this.toSingleTermIterator((PredicateQuery.Feature)e, featureIndex)).filter(Optional::isPresent).map(Optional::get).forEach(iterators::add);
        }

        private Optional<ConjunctionIdIterator> toSingleTermIterator(PredicateQuery.Feature feature, FeatureIndex featureIndex) {
            return featureIndex.getConjunctionIdsForFeature(feature.featureHash).map(conjunctions -> new ConjunctionIdIterator(feature.subqueryBitmap, (int[])conjunctions));
        }

        private void findMatchingConjunctions(int k, List<ConjunctionIdIterator> iterators, List<ConjunctionHit> matchingIds, byte[] iteratorsPerConjunction) {
            int nextId;
            if (k == 0) {
                k = 1;
            }
            if ((nextId = this.getNextId(0, k, iteratorsPerConjunction)) == -1) {
                return;
            }
            int nIterators = iterators.size();
            if (nIterators < k) {
                return;
            }
            short[] sortedIndexes = new short[nIterators];
            short[] sortedIndexesMergeBuffer = new short[nIterators];
            for (int i = 0; i < nIterators; i = (int)((short)(i + 1))) {
                sortedIndexes[i] = i;
            }
            int[] currentIds = new int[nIterators];
            int nCompleted = this.initializeIterators(iterators, sortedIndexes, currentIds, nextId);
            nIterators -= nCompleted;
            while (nIterators >= k) {
                boolean swapMergeBuffer;
                short index;
                int i;
                int id0 = currentIds[sortedIndexes[0]];
                int idK = currentIds[sortedIndexes[k - 1]];
                if (ConjunctionId.equals(id0, idK)) {
                    int firstPositive;
                    long matchingSubqueries = -1L;
                    for (firstPositive = 0; firstPositive < nIterators && !ConjunctionId.isPositive(currentIds[sortedIndexes[firstPositive]]); ++firstPositive) {
                        matchingSubqueries &= iterators.get(sortedIndexes[firstPositive]).getSubqueryBitmap() ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (firstPositive + k <= nIterators && (id0 = currentIds[sortedIndexes[firstPositive]]) == (idK = currentIds[sortedIndexes[firstPositive + k - 1]])) {
                        for (int i2 = firstPositive; i2 < firstPositive + k; ++i2) {
                            matchingSubqueries &= iterators.get(sortedIndexes[i2]).getSubqueryBitmap();
                        }
                        if (matchingSubqueries != 0L) {
                            matchingIds.add(new ConjunctionHit(this.toExternalId(id0), matchingSubqueries));
                        }
                    }
                }
                if ((nextId = this.getNextId(ConjunctionId.nextId(id0), k, iteratorsPerConjunction)) == -1) {
                    return;
                }
                int completed = 0;
                for (i = 0; i < nIterators && ConjunctionId.compare(currentIds[index = sortedIndexes[i]], nextId) < 0; ++i) {
                    ConjunctionIdIterator iterator = iterators.get(index);
                    if (iterator.next(nextId)) {
                        currentIds[index] = iterator.getConjunctionId();
                        continue;
                    }
                    currentIds[index] = Integer.MAX_VALUE;
                    ++completed;
                }
                if (i > 0 && nIterators - completed >= k && (swapMergeBuffer = PrimitiveArraySorter.sortAndMerge(sortedIndexes, sortedIndexesMergeBuffer, i, nIterators, (a, b) -> Integer.compare(currentIds[a], currentIds[b])))) {
                    short[] temp = sortedIndexes;
                    sortedIndexes = sortedIndexesMergeBuffer;
                    sortedIndexesMergeBuffer = temp;
                }
                nIterators -= completed;
            }
        }

        private int initializeIterators(List<ConjunctionIdIterator> iterators, short[] sortedIndexes, int[] currentIds, int nextId) {
            int nCompleted = 0;
            int nIterators = iterators.size();
            for (int i = 0; i < nIterators; ++i) {
                ConjunctionIdIterator iterator = iterators.get(i);
                if (iterator.next(nextId)) {
                    currentIds[i] = iterator.getConjunctionId();
                    continue;
                }
                currentIds[i] = Integer.MAX_VALUE;
                ++nCompleted;
            }
            PrimitiveArraySorter.sort(sortedIndexes, (a, b) -> Integer.compare(currentIds[a], currentIds[b]));
            return nCompleted;
        }

        private int getNextId(int fromId, int k, byte[] iteratorsPerConjunction) {
            int id;
            int nDocuments = iteratorsPerConjunction.length;
            for (id = fromId >>> 1; id < nDocuments && iteratorsPerConjunction[id] < k; ++id) {
            }
            return id == nDocuments ? -1 : id << 1 | 1;
        }

        private long toExternalId(int internalId) {
            return ConjunctionIndex.this.idMapping[internalId >>> 1];
        }
    }

    public static class FeatureIndex {
        private final LongObjectMap<int[]> map;

        public FeatureIndex(LongObjectMap<int[]> map) {
            this.map = map;
        }

        public Optional<int[]> getConjunctionIdsForFeature(long featureId) {
            return Optional.ofNullable(this.map.get(featureId));
        }

        public void writeToOutputStream(DataOutputStream out) throws IOException {
            out.writeInt(this.map.size());
            for (LongObjectPair p : this.map.keyValuesView()) {
                out.writeLong(p.getOne());
                SerializationHelper.writeIntArray((int[])p.getTwo(), out);
            }
        }

        public static FeatureIndex fromInputStream(DataInputStream in) throws IOException {
            int mapSize = in.readInt();
            LongObjectHashMap map = new LongObjectHashMap(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                long key = in.readLong();
                map.put(key, (Object)SerializationHelper.readIntArray(in));
            }
            map.compact();
            return new FeatureIndex((LongObjectMap<int[]>)map);
        }
    }
}

