/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index;

import com.yahoo.search.predicate.Hit;
import com.yahoo.search.predicate.index.Interval;
import com.yahoo.search.predicate.index.PostingList;
import com.yahoo.search.predicate.utils.PrimitiveArraySorter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PredicateSearch {
    private final PostingList[] postingLists;
    private final byte[] nPostingListsForDocument;
    private final byte[] minFeatureIndex;
    private final int[] docIds;
    private final int[] intervals;
    private final long[] subqueries;
    private final long[] subqueryMarkers;
    private final boolean[] visited;
    private final short[] intervalEnds;
    private short[] sortedIndexes;
    private short[] sortedIndexesMergeBuffer;
    private int nPostingLists;

    public PredicateSearch(List<PostingList> postingLists, byte[] nPostingListsForDocument, byte[] minFeatureIndex, short[] intervalEnds, int highestIntervalEnd) {
        int size = postingLists.size();
        this.nPostingListsForDocument = nPostingListsForDocument;
        this.minFeatureIndex = minFeatureIndex;
        this.nPostingLists = size;
        this.postingLists = postingLists.toArray(new PostingList[postingLists.size()]);
        this.sortedIndexes = new short[size];
        this.sortedIndexesMergeBuffer = new short[size];
        this.docIds = new int[size];
        this.intervals = new int[size];
        this.subqueries = new long[size];
        this.subqueryMarkers = new long[highestIntervalEnd + 1];
        this.visited = new boolean[highestIntervalEnd + 1];
        this.intervalEnds = intervalEnds;
        Arrays.sort(this.postingLists, (l, r) -> -Integer.compare(l.size(), r.size()));
        for (int i = 0; i < size; i = (int)((short)(i + 1))) {
            PostingList postingList = this.postingLists[i];
            this.sortedIndexes[i] = i;
            this.docIds[i] = postingList.getDocId();
            this.subqueries[i] = postingList.getSubquery();
        }
    }

    public Stream<Hit> stream() {
        if (this.nPostingLists == 0) {
            return Stream.empty();
        }
        return StreamSupport.stream(new PredicateSpliterator(), false);
    }

    private Optional<Hit> seek(int docId) {
        boolean skippedToEnd = this.skipMinFeature(docId);
        while (this.nPostingLists > 0 && !skippedToEnd) {
            int docIdK;
            int docId0 = this.docIds[this.sortedIndexes[0]];
            byte minFeature = this.minFeatureIndex[docId0];
            int k = minFeature > 0 ? minFeature - 1 : 0;
            int intervalEnd = Short.toUnsignedInt(this.intervalEnds[docId0]);
            if (k < this.nPostingLists && docId0 == (docIdK = this.docIds[this.sortedIndexes[k]]) && this.evaluateHit(docId0, k, intervalEnd)) {
                return Optional.of(new Hit(docId0, this.subqueryMarkers[intervalEnd]));
            }
            skippedToEnd = this.skipMinFeature(docId0 + 1);
        }
        return Optional.empty();
    }

    private boolean skipMinFeature(int docId) {
        int nDocuments = this.nPostingListsForDocument.length;
        while (docId < nDocuments && this.minFeatureIndex[docId] > this.nPostingListsForDocument[docId]) {
            ++docId;
        }
        if (docId < nDocuments) {
            this.advanceAllTo(docId);
            return false;
        }
        return true;
    }

    private boolean evaluateHit(int docId, int k, int intervalEnd) {
        int candidates;
        for (int i = candidates = k + 1; i < this.nPostingLists && this.docIds[this.sortedIndexes[i]] == docId; ++i) {
            ++candidates;
        }
        int nNoIntervalIterators = 0;
        for (int i = 0; i < candidates; ++i) {
            short index = this.sortedIndexes[i];
            PostingList postingList = this.postingLists[index];
            if (postingList.prepareIntervals()) {
                this.intervals[index] = postingList.getInterval();
                continue;
            }
            ++nNoIntervalIterators;
            this.intervals[index] = -1;
        }
        PrimitiveArraySorter.sort(this.sortedIndexes, 0, candidates, (a, b) -> Integer.compareUnsigned(this.intervals[a], this.intervals[b]));
        candidates -= nNoIntervalIterators;
        Arrays.fill(this.subqueryMarkers, 0, intervalEnd + 1, 0L);
        this.subqueryMarkers[0] = -1L;
        Arrays.fill(this.visited, 0, intervalEnd + 1, false);
        this.visited[0] = true;
        int highestEndSeen = 1;
        int i = 0;
        while (i < candidates) {
            short index = this.sortedIndexes[i];
            int lastEnd = this.addInterval(index, highestEndSeen);
            if (lastEnd == -1) {
                return false;
            }
            highestEndSeen = Math.max(lastEnd, highestEndSeen);
            PostingList postingList = this.postingLists[index];
            if (postingList.nextInterval()) {
                this.intervals[index] = postingList.getInterval();
                this.restoreSortedOrder(i, candidates);
                continue;
            }
            ++i;
        }
        return this.subqueryMarkers[intervalEnd] != 0L;
    }

    private void restoreSortedOrder(int first, int last) {
        short indexToMove = this.sortedIndexes[first];
        long intervalToMove = Integer.toUnsignedLong(this.intervals[indexToMove]);
        while (++first < last && intervalToMove > Integer.toUnsignedLong(this.intervals[this.sortedIndexes[first]])) {
            this.sortedIndexes[first - 1] = this.sortedIndexes[first];
        }
        this.sortedIndexes[first - 1] = indexToMove;
    }

    private int addInterval(int index, int highestEndSeen) {
        int interval = this.intervals[index];
        long subqueryBitMap = this.subqueries[index];
        if (Interval.isZStar1Interval(interval)) {
            int begin = Interval.getZStar1Begin(interval);
            int end = Interval.getZStar1End(interval);
            if (highestEndSeen < begin) {
                return -1;
            }
            this.markSubquery(begin, end, this.subqueryMarkers[begin] ^ 0xFFFFFFFFFFFFFFFFL);
            return end;
        }
        int begin = Interval.getBegin(interval);
        int end = Interval.getEnd(interval);
        if (highestEndSeen < begin - 1) {
            return -1;
        }
        this.markSubquery(begin - 1, end, this.subqueryMarkers[begin - 1] & subqueryBitMap);
        return end;
    }

    private void markSubquery(int begin, int end, long subqueryBitmap) {
        if (this.visited[begin]) {
            this.visited[end] = true;
            int n = end;
            this.subqueryMarkers[n] = this.subqueryMarkers[n] | subqueryBitmap;
        }
    }

    private void advanceAllTo(int docId) {
        int i;
        int completedCount = 0;
        for (i = 0; i < this.nPostingLists && this.docIds[this.sortedIndexes[i]] < docId; ++i) {
            if (this.advanceOneTo(docId, i)) continue;
            ++completedCount;
        }
        if (i > 0 && this.nPostingLists > completedCount) {
            this.sortIndexes(i);
        }
        this.nPostingLists -= completedCount;
    }

    private boolean advanceOneTo(int docId, int index) {
        short i = this.sortedIndexes[index];
        PostingList postingList = this.postingLists[i];
        if (postingList.nextDocument(docId - 1)) {
            this.docIds[i] = postingList.getDocId();
            return true;
        }
        this.docIds[i] = Integer.MAX_VALUE;
        return false;
    }

    private void sortIndexes(int numUpdated) {
        boolean swapMergeBuffer = PrimitiveArraySorter.sortAndMerge(this.sortedIndexes, this.sortedIndexesMergeBuffer, numUpdated, this.nPostingLists, (a, b) -> Integer.compare(this.docIds[a], this.docIds[b]));
        if (swapMergeBuffer) {
            short[] temp = this.sortedIndexes;
            this.sortedIndexes = this.sortedIndexesMergeBuffer;
            this.sortedIndexesMergeBuffer = temp;
        }
    }

    private class PredicateSpliterator
    implements Spliterator<Hit> {
        private int lastHit = -1;

        private PredicateSpliterator() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super Hit> action) {
            Optional optionalHit = PredicateSearch.this.seek(this.lastHit + 1);
            optionalHit.ifPresent(hit -> {
                this.lastHit = hit.getDocId();
                action.accept((Hit)hit);
            });
            return optionalHit.isPresent();
        }

        @Override
        public Spliterator<Hit> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 277;
        }

        @Override
        public Comparator<Hit> getComparator() {
            return null;
        }
    }
}

