/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public class PredicateQueryParser {
    private final JsonFactory factory = new JsonFactory();

    public void parseJsonQuery(String json, FeatureHandler<String> featureHandler, FeatureHandler<Long> rangeFeatureHandler) throws IllegalArgumentException {
        try (JsonParser parser = this.factory.createParser(json);){
            PredicateQueryParser.skipToken(parser, JsonToken.START_OBJECT);
            block17: while (parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName;
                switch (fieldName = parser.getCurrentName()) {
                    case "features": {
                        PredicateQueryParser.parseFeatures(parser, JsonParser::getText, featureHandler);
                        continue block17;
                    }
                    case "rangeFeatures": {
                        PredicateQueryParser.parseFeatures(parser, JsonParser::getLongValue, rangeFeatureHandler);
                        continue block17;
                    }
                }
                throw new IllegalArgumentException("Invalid field name: " + fieldName);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AssertionError("This should never happen when parsing from a String", e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Parsing query from JSON failed: '%s'", json), e);
        }
    }

    private static <V> void parseFeatures(JsonParser parser, ValueParser<V> valueParser, FeatureHandler<V> featureHandler) throws IOException {
        PredicateQueryParser.skipToken(parser, JsonToken.START_ARRAY);
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            PredicateQueryParser.parseFeature(parser, valueParser, featureHandler);
        }
    }

    private static <V> void parseFeature(JsonParser parser, ValueParser<V> valueParser, FeatureHandler<V> featureHandler) throws IOException {
        String key = null;
        Object value = null;
        long subqueryBitmap = -1L;
        block10: while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            PredicateQueryParser.skipToken(parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT);
            switch (fieldName) {
                case "k": {
                    key = parser.getText();
                    continue block10;
                }
                case "v": {
                    value = valueParser.parse(parser);
                    continue block10;
                }
                case "s": {
                    subqueryBitmap = PredicateQueryParser.fromHexString(parser.getText());
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid field name: " + fieldName);
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Feature key is missing! (%s)", parser.getCurrentLocation()));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Feature value is missing! (%s)", parser.getCurrentLocation()));
        }
        featureHandler.accept(key, value, subqueryBitmap);
    }

    private static void skipToken(JsonParser parser, JsonToken ... expected) throws IOException {
        JsonToken actual = parser.nextToken();
        if (!ArrayUtils.contains((Object[])expected, (Object)actual)) {
            throw new IllegalArgumentException(String.format("Expected a token in %s, got %s (%s).", Arrays.toString(expected), actual, parser.getTokenLocation()));
        }
    }

    private static long fromHexString(String subqueryBitmap) {
        if (!subqueryBitmap.startsWith("0x")) {
            throw new IllegalArgumentException("Not a valid subquery bitmap ('0x' prefix missing): " + subqueryBitmap);
        }
        return Long.parseUnsignedLong(subqueryBitmap.substring(2), 16);
    }

    @FunctionalInterface
    private static interface ValueParser<V> {
        public V parse(JsonParser var1) throws IOException;
    }

    @FunctionalInterface
    public static interface FeatureHandler<V> {
        public void accept(String var1, V var2, long var3);
    }
}

