/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.PredicateValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class FeatureSet
extends PredicateValue {
    private Set<String> values;
    private String key;

    public FeatureSet(String key, String ... values) {
        this(key, Arrays.asList(values));
    }

    public FeatureSet(String key, Collection<String> values) {
        Objects.requireNonNull(key, "key");
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.key = key;
        this.values = new TreeSet<String>(values);
    }

    public FeatureSet setKey(String key) {
        Objects.requireNonNull(key, "key");
        this.key = key;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public FeatureSet addValue(String value) {
        Objects.requireNonNull(value, "value");
        this.values.add(value);
        return this;
    }

    public FeatureSet addValues(Collection<String> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.values.addAll(values);
        return this;
    }

    public FeatureSet setValues(Collection<String> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.values.clear();
        this.values.addAll(values);
        return this;
    }

    public Set<String> getValues() {
        return this.values;
    }

    @Override
    public FeatureSet clone() throws CloneNotSupportedException {
        FeatureSet obj = (FeatureSet)super.clone();
        obj.values = new TreeSet<String>(this.values);
        return obj;
    }

    public int hashCode() {
        return (this.key.hashCode() + this.values.hashCode()) * 31;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FeatureSet)) {
            return false;
        }
        FeatureSet rhs = (FeatureSet)obj;
        if (!this.key.equals(rhs.key)) {
            return false;
        }
        return this.values.equals(rhs.values);
    }

    @Override
    protected void appendTo(StringBuilder out) {
        this.appendInAsTo("in", out);
    }

    protected void appendNegatedTo(StringBuilder out) {
        this.appendInAsTo("not in", out);
    }

    private void appendInAsTo(String in, StringBuilder out) {
        FeatureSet.appendQuotedTo(this.key, out);
        out.append(' ').append(in).append(" [");
        Iterator<String> it = this.values.iterator();
        while (it.hasNext()) {
            FeatureSet.appendQuotedTo(it.next(), out);
            if (!it.hasNext()) continue;
            out.append(", ");
        }
        out.append("]");
    }
}

