/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.Predicate;
import java.util.ArrayList;
import java.util.List;

public class SimplePredicates {
    public static Predicate newPredicate() {
        return new Predicate(){

            @Override
            protected void appendTo(StringBuilder out) {
                out.append("<anon>");
            }
        };
    }

    public static Predicate newString(String str) {
        return new StringNode(str);
    }

    public static List<Predicate> newStrings(String ... arr) {
        ArrayList<Predicate> ret = new ArrayList<Predicate>(arr.length);
        for (String str : arr) {
            ret.add(SimplePredicates.newString(str));
        }
        return ret;
    }

    private static class StringNode
    extends Predicate {
        final String str;

        StringNode(String str) {
            this.str = str;
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StringNode)) {
                return false;
            }
            StringNode rhs = (StringNode)obj;
            return this.str.equals(rhs.str);
        }

        @Override
        protected void appendTo(StringBuilder out) {
            out.append(this.str);
        }
    }
}

