/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.predicate;

import com.yahoo.document.predicate.BinaryFormat;
import com.yahoo.document.predicate.parser.PredicateLexer;
import com.yahoo.document.predicate.parser.PredicateParser;
import com.yahoo.text.Ascii;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public abstract class Predicate
implements Cloneable {
    private static final char QUOTE_CHAR = '\'';
    private static final Ascii.Encoder ASCII_ENCODER = Ascii.newEncoder((Charset)StandardCharsets.UTF_8, (int[])new int[]{39});
    private static final Ascii.Decoder ASCII_DECODER = Ascii.newDecoder((Charset)StandardCharsets.UTF_8);

    public Predicate clone() throws CloneNotSupportedException {
        return (Predicate)super.clone();
    }

    public final String toString() {
        StringBuilder out = new StringBuilder();
        this.appendTo(out);
        return out.toString();
    }

    protected abstract void appendTo(StringBuilder var1);

    protected static void appendQuotedTo(String str, StringBuilder out) {
        String encoded = Predicate.asciiEncode(str);
        if (Predicate.requiresQuote(encoded)) {
            out.append('\'').append(encoded).append('\'');
        } else {
            out.append(str);
        }
    }

    private static boolean requiresQuote(String str) {
        int i = 0;
        int len = str.length();
        while (i < len) {
            int c = str.codePointAt(i);
            if (c == 92 || !Character.isLetterOrDigit(c)) {
                return true;
            }
            i = str.offsetByCodePoints(i, 1);
        }
        return false;
    }

    public static String asciiEncode(String str) {
        return ASCII_ENCODER.encode(str);
    }

    public static String asciiDecode(String str) {
        return ASCII_DECODER.decode(str);
    }

    public static Predicate fromBinary(byte[] buf) {
        return BinaryFormat.decode(buf);
    }

    public static Predicate fromString(String str) {
        ANTLRStringStream input = new ANTLRStringStream(str);
        PredicateLexer lexer = new PredicateLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PredicateParser parser = new PredicateParser((TokenStream)tokens);
        try {
            return parser.predicate();
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

