/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.optimization;

import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.search.predicate.optimization.PredicateOptions;
import com.yahoo.search.predicate.optimization.PredicateProcessor;
import java.util.ArrayList;
import java.util.List;

public class AndOrSimplifier
implements PredicateProcessor {
    public Predicate simplifySubTree(Predicate predicate, boolean negated) {
        if (predicate == null) {
            return null;
        }
        if (predicate instanceof Negation) {
            return this.simplifySubTree(((Negation)predicate).getOperand(), !negated);
        }
        if (predicate instanceof Conjunction) {
            List<Predicate> in = ((Conjunction)predicate).getOperands();
            ArrayList<Predicate> out = new ArrayList<Predicate>(in.size());
            for (Predicate operand : in) {
                if ((operand = this.simplifySubTree(operand, negated)) instanceof Conjunction) {
                    out.addAll(((Conjunction)operand).getOperands());
                    continue;
                }
                out.add(operand);
            }
            if (negated) {
                return new Disjunction(out);
            }
            ((Conjunction)predicate).setOperands(out);
        } else if (predicate instanceof Disjunction) {
            List<Predicate> in = ((Disjunction)predicate).getOperands();
            ArrayList<Predicate> out = new ArrayList<Predicate>(in.size());
            for (Predicate operand : in) {
                if ((operand = this.simplifySubTree(operand, negated)) instanceof Disjunction) {
                    out.addAll(((Disjunction)operand).getOperands());
                    continue;
                }
                out.add(operand);
            }
            if (negated) {
                return new Conjunction(out);
            }
            ((Disjunction)predicate).setOperands(out);
        } else if (negated) {
            return new Negation(predicate);
        }
        return predicate;
    }

    @Override
    public Predicate process(Predicate predicate, PredicateOptions options) {
        return this.simplifySubTree(predicate, false);
    }
}

