/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.xgboost;

import ai.vespa.rankingexpression.importer.xgboost.AbstractXGBoostParser;
import ai.vespa.rankingexpression.importer.xgboost.XGBoostTree;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.json.Jackson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class XGBoostParser
extends AbstractXGBoostParser {
    private final List<XGBoostTree> xgboostTrees = new ArrayList<XGBoostTree>();

    XGBoostParser(String filePath) throws JsonProcessingException, IOException {
        ObjectMapper mapper = Jackson.mapper();
        JsonNode forestNode = mapper.readTree(new File(filePath));
        for (JsonNode treeNode : forestNode) {
            this.xgboostTrees.add((XGBoostTree)mapper.treeToValue((TreeNode)treeNode, XGBoostTree.class));
        }
    }

    String toRankingExpression() {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.xgboostTrees.size(); ++i) {
            ret.append(this.treeToRankExp(this.xgboostTrees.get(i)));
            if (i == this.xgboostTrees.size() - 1) continue;
            ret.append(" + \n");
        }
        return ret.toString();
    }
}

