/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.xgboost;

import ai.vespa.rankingexpression.importer.xgboost.XGBoostTree;

abstract class AbstractXGBoostParser {
    AbstractXGBoostParser() {
    }

    protected String treeToRankExp(XGBoostTree node) {
        String falseExp;
        String trueExp;
        if (node.isLeaf()) {
            return Double.toString(node.getLeaf());
        }
        assert (node.getChildren().size() == 2);
        if (node.getYes() == node.getChildren().get(0).getNodeid()) {
            trueExp = this.treeToRankExp(node.getChildren().get(0));
            falseExp = this.treeToRankExp(node.getChildren().get(1));
        } else {
            trueExp = this.treeToRankExp(node.getChildren().get(1));
            falseExp = this.treeToRankExp(node.getChildren().get(0));
        }
        float xgbSplitPoint = (float)node.getSplit_condition();
        double vespaSplitPoint = xgbSplitPoint;
        String formattedSplit = this.formatSplit(node.getSplit());
        String condition = node.getMissing() == node.getYes() ? "!(" + formattedSplit + " >= " + vespaSplitPoint + ")" : formattedSplit + " < " + vespaSplitPoint;
        return "if (" + condition + ", " + trueExp + ", " + falseExp + ")";
    }

    protected String formatSplit(String split) {
        try {
            Integer.parseInt(split);
            return "xgboost_input_" + split;
        }
        catch (NumberFormatException e) {
            return split;
        }
    }
}

