/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.triton;

import ai.vespa.llm.clients.TritonConfig;
import ai.vespa.modelintegration.evaluator.OnnxEvaluator;
import ai.vespa.modelintegration.evaluator.OnnxEvaluatorOptions;
import ai.vespa.modelintegration.evaluator.OnnxRuntime;
import ai.vespa.triton.TritonOnnxClient;
import ai.vespa.triton.TritonOnnxEvaluator;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.vespa.defaults.Defaults;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class TritonOnnxRuntime
extends AbstractComponent
implements OnnxRuntime {
    private final TritonConfig config;
    private final TritonOnnxClient client;

    public TritonOnnxRuntime() {
        this(new TritonConfig.Builder().build());
    }

    @Inject
    public TritonOnnxRuntime(TritonConfig config) {
        this.config = config;
        this.client = new TritonOnnxClient(config);
    }

    @Override
    public OnnxEvaluator evaluatorOf(String modelPath) {
        boolean isExplicitControlMode;
        boolean bl = isExplicitControlMode = this.config.modelControlMode() == TritonConfig.ModelControlMode.EXPLICIT;
        if (isExplicitControlMode) {
            this.copyModelToRepository(modelPath);
        }
        return new TritonOnnxEvaluator(this.client, TritonOnnxRuntime.modelName(modelPath), isExplicitControlMode);
    }

    @Override
    public OnnxEvaluator evaluatorOf(String modelPath, OnnxEvaluatorOptions options) {
        return this.evaluatorOf(modelPath);
    }

    public void deconstruct() {
        this.client.close();
    }

    private void copyModelToRepository(String externalModelPath) {
        String modelRepository = Defaults.getDefaults().underVespaHome(this.config.modelRepositoryPath());
        Path repositoryModelRoot = Paths.get(modelRepository, TritonOnnxRuntime.modelName(externalModelPath), "1");
        Path repositoryModelFile = repositoryModelRoot.resolve("model.onnx");
        try {
            Files.createDirectories(repositoryModelRoot, new FileAttribute[0]);
            Files.copy(Paths.get(externalModelPath, new String[0]), repositoryModelFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy model file to repository", e);
        }
    }

    private static String modelName(String modelPath) {
        String name = modelPath.substring(modelPath.lastIndexOf(47) + 1);
        return name.substring(0, name.lastIndexOf(46));
    }
}

