/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.triton;

import ai.vespa.llm.clients.TritonConfig;
import ai.vespa.modelintegration.evaluator.OnnxEvaluator;
import ai.vespa.modelintegration.evaluator.OnnxEvaluatorOptions;
import ai.vespa.modelintegration.evaluator.OnnxRuntime;
import ai.vespa.triton.TritonOnnxEvaluator;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.vespa.defaults.Defaults;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class TritonOnnxRuntime
extends AbstractComponent
implements OnnxRuntime {
    private final TritonConfig config;

    public TritonOnnxRuntime() {
        this(new TritonConfig.Builder().build());
    }

    @Inject
    public TritonOnnxRuntime(TritonConfig config) {
        this.config = config;
    }

    @Override
    public OnnxEvaluator evaluatorOf(String modelPath) {
        return new TritonOnnxEvaluator(this.config, this.copyFileToRepositoryAndGetModelId(modelPath));
    }

    @Override
    public OnnxEvaluator evaluatorOf(String modelPath, OnnxEvaluatorOptions options) {
        return this.evaluatorOf(modelPath);
    }

    private String copyFileToRepositoryAndGetModelId(String externalModelPath) {
        String modelRepository = Defaults.getDefaults().underVespaHome(this.config.modelRepositoryPath());
        String modelName = externalModelPath.substring(externalModelPath.lastIndexOf(47) + 1);
        modelName = modelName.substring(0, modelName.lastIndexOf(46));
        Path repositoryModelRoot = Paths.get(modelRepository, modelName, "1");
        Path repositoryModelFile = repositoryModelRoot.resolve("model.onnx");
        try {
            Files.createDirectories(repositoryModelRoot, new FileAttribute[0]);
            Files.copy(Paths.get(externalModelPath, new String[0]), repositoryModelFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy model file to repository", e);
        }
        return modelName;
    }
}

