/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;
import java.util.Optional;

public final class OnnxConstant
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;
    private final Value value;

    public OnnxConstant(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
        this.value = this.value();
        this.setConstantValueFunction(type -> new TensorValue(this.value.asTensor()));
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        OrderedTensorType type = this.value instanceof TensorValue ? OrderedTensorType.fromSpec(this.value.type().toString()).rename(this.vespaName() + "_") : OrderedTensorType.fromDimensionList(TensorType.Value.DOUBLE, List.of());
        return type;
    }

    @Override
    protected TensorFunction<Reference> lazyGetFunction() {
        return null;
    }

    @Override
    public Optional<Value> getConstantValue() {
        return Optional.of(new TensorValue(this.value.asTensor().withType(this.type().get().type())));
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        this.addConstraintsFrom(this.type, renamer);
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public OnnxConstant withInputs(List<IntermediateOperation> inputs) {
        return new OnnxConstant(this.modelName(), this.name(), inputs, this.attributeMap);
    }

    @Override
    public String operationName() {
        return "Constant";
    }

    @Override
    public String toString() {
        return "Constant(" + String.valueOf(this.type) + ")";
    }

    @Override
    public String toFullString() {
        return "\t" + String.valueOf(this.type) + ":\tConstant(" + String.valueOf(this.type) + ")";
    }

    private Value value() {
        Optional<Value> value = this.attributeMap.get("value");
        if (value.isEmpty() && (value = this.attributeMap.get("value_float")).isEmpty()) {
            value = this.attributeMap.get("value_int");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Node '" + this.name + "' of type constant has missing or non-supported 'value' attribute");
        }
        return value.get();
    }
}

