/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import ai.vespa.llm.InferenceParameters;
import ai.vespa.llm.client.openai.OpenAiClient;
import ai.vespa.llm.clients.ConfigurableLanguageModel;
import ai.vespa.llm.clients.LlmClientConfig;
import ai.vespa.llm.completion.Completion;
import ai.vespa.llm.completion.Prompt;
import ai.vespa.secret.Secrets;
import com.yahoo.api.annotations.Beta;
import com.yahoo.component.annotation.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

@Beta
public class OpenAI
extends ConfigurableLanguageModel {
    private final OpenAiClient client = new OpenAiClient();
    private final Map<String, String> configOptions = new HashMap<String, String>();

    @Inject
    public OpenAI(LlmClientConfig config, Secrets secretStore) {
        super(config, secretStore);
        if (!config.model().isBlank()) {
            this.configOptions.put("model", config.model());
        }
        if (config.temperature() >= 0.0) {
            this.configOptions.put("temperature", String.valueOf(config.temperature()));
        }
        if (config.maxTokens() >= 0) {
            this.configOptions.put("maxTokens", String.valueOf(config.maxTokens()));
        }
    }

    private InferenceParameters prepareParameters(InferenceParameters parameters) {
        this.setApiKey(parameters);
        this.setEndpoint(parameters);
        InferenceParameters combinedParameters = parameters.withDefaultOptions(this.configOptions::get);
        return combinedParameters;
    }

    public List<Completion> complete(Prompt prompt, InferenceParameters parameters) {
        InferenceParameters preparedParameters = this.prepareParameters(parameters);
        return this.client.complete(prompt, preparedParameters);
    }

    public CompletableFuture<Completion.FinishReason> completeAsync(Prompt prompt, InferenceParameters parameters, Consumer<Completion> consumer) {
        InferenceParameters preparedParameters = this.prepareParameters(parameters);
        return this.client.completeAsync(prompt, preparedParameters, consumer);
    }
}

