/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.clients;

import ai.vespa.llm.InferenceParameters;
import ai.vespa.llm.LanguageModel;
import ai.vespa.llm.clients.LlmClientConfig;
import com.yahoo.api.annotations.Beta;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import java.util.logging.Logger;

@Beta
public abstract class ConfigurableLanguageModel
implements LanguageModel {
    private static Logger log = Logger.getLogger(ConfigurableLanguageModel.class.getName());
    private final String apiKey;
    private final String endpoint;

    public ConfigurableLanguageModel() {
        this.apiKey = null;
        this.endpoint = null;
    }

    @Inject
    public ConfigurableLanguageModel(LlmClientConfig config, SecretStore secretStore) {
        this.apiKey = ConfigurableLanguageModel.findApiKeyInSecretStore(config.apiKeySecretName(), secretStore);
        this.endpoint = config.endpoint();
    }

    private static String findApiKeyInSecretStore(String property, SecretStore secretStore) {
        String apiKey = "";
        if (property != null && !property.isEmpty()) {
            try {
                apiKey = secretStore.getSecret(property);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception e) {
                log.warning("Secret store look up failed: " + e.getMessage() + "\nWill expect API key in request header");
            }
        }
        return apiKey;
    }

    protected String getApiKey(InferenceParameters params) {
        return params.getApiKey().orElse(null);
    }

    protected void setApiKey(InferenceParameters params) {
        if (params.getApiKey().isEmpty() && this.apiKey != null) {
            params.setApiKey(this.apiKey);
        }
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected void setEndpoint(InferenceParameters params) {
        if (this.endpoint != null && !this.endpoint.isEmpty()) {
            params.setEndpoint(this.endpoint);
        }
    }
}

