/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.evaluator;

import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;

public class OnnxEvaluatorOptions {
    private OrtSession.SessionOptions.OptLevel optimizationLevel = OrtSession.SessionOptions.OptLevel.ALL_OPT;
    private OrtSession.SessionOptions.ExecutionMode executionMode = OrtSession.SessionOptions.ExecutionMode.SEQUENTIAL;
    private int interOpThreads = 1;
    private int intraOpThreads = Math.max(1, (int)Math.ceil((double)Runtime.getRuntime().availableProcessors() / 4.0));

    public OrtSession.SessionOptions getOptions() throws OrtException {
        OrtSession.SessionOptions options = new OrtSession.SessionOptions();
        options.setOptimizationLevel(this.optimizationLevel);
        options.setExecutionMode(this.executionMode);
        options.setInterOpNumThreads(this.interOpThreads);
        options.setIntraOpNumThreads(this.intraOpThreads);
        return options;
    }

    public void setExecutionMode(String mode) {
        if ("parallel".equalsIgnoreCase(mode)) {
            this.executionMode = OrtSession.SessionOptions.ExecutionMode.PARALLEL;
        } else if ("sequential".equalsIgnoreCase(mode)) {
            this.executionMode = OrtSession.SessionOptions.ExecutionMode.SEQUENTIAL;
        }
    }

    public void setInterOpThreads(int threads) {
        if (threads >= 0) {
            this.interOpThreads = threads;
        }
    }

    public void setIntraOpThreads(int threads) {
        if (threads >= 0) {
            this.intraOpThreads = threads;
        }
    }
}

