/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.onnx;

import ai.vespa.rankingexpression.importer.OrderedTensorType;
import com.google.protobuf.ByteString;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import onnx.Onnx;

class TensorConverter {
    TensorConverter() {
    }

    static Tensor toVespaTensor(Onnx.TensorProto tensorProto, OrderedTensorType type) {
        Values values = TensorConverter.readValuesOf(tensorProto);
        IndexedTensor.BoundBuilder builder = (IndexedTensor.BoundBuilder)Tensor.Builder.of((TensorType)type.type());
        for (int i = 0; i < values.size(); ++i) {
            builder.cellByDirectIndex(type.toDirectIndex(i), values.get(i));
        }
        return builder.build();
    }

    private static Values readValuesOf(Onnx.TensorProto tensorProto) {
        if (tensorProto.hasRawData()) {
            switch (tensorProto.getDataType()) {
                case BOOL: {
                    return new RawBoolValues(tensorProto);
                }
                case FLOAT: {
                    return new RawFloatValues(tensorProto);
                }
                case DOUBLE: {
                    return new RawDoubleValues(tensorProto);
                }
                case INT32: {
                    return new RawIntValues(tensorProto);
                }
                case INT64: {
                    return new RawLongValues(tensorProto);
                }
            }
        } else {
            switch (tensorProto.getDataType()) {
                case FLOAT: {
                    return new FloatValues(tensorProto);
                }
                case DOUBLE: {
                    return new DoubleValues(tensorProto);
                }
                case INT32: {
                    return new IntValues(tensorProto);
                }
                case INT64: {
                    return new LongValues(tensorProto);
                }
            }
        }
        throw new IllegalArgumentException("Cannot convert a tensor with elements of type " + tensorProto.getDataType() + " to a Vespa tensor");
    }

    private static abstract class Values {
        private Values() {
        }

        abstract double get(int var1);

        abstract int size();
    }

    private static class RawBoolValues
    extends RawValues {
        private final ByteString values;
        private final int size;

        RawBoolValues(Onnx.TensorProto tensorProto) {
            this.values = tensorProto.getRawData();
            this.size = this.values.size();
        }

        @Override
        double get(int i) {
            return this.values.byteAt(i) == 0 ? 0.0 : 1.0;
        }

        @Override
        int size() {
            return this.size;
        }
    }

    private static class RawFloatValues
    extends RawValues {
        private final FloatBuffer values;
        private final int size;

        RawFloatValues(Onnx.TensorProto tensorProto) {
            this.values = this.bytes(tensorProto).asFloatBuffer();
            this.size = this.values.remaining();
        }

        @Override
        double get(int i) {
            return this.values.get(i);
        }

        @Override
        int size() {
            return this.size;
        }
    }

    private static class RawDoubleValues
    extends RawValues {
        private final DoubleBuffer values;
        private final int size;

        RawDoubleValues(Onnx.TensorProto tensorProto) {
            this.values = this.bytes(tensorProto).asDoubleBuffer();
            this.size = this.values.remaining();
        }

        @Override
        double get(int i) {
            return this.values.get(i);
        }

        @Override
        int size() {
            return this.size;
        }
    }

    private static class RawIntValues
    extends RawValues {
        private final IntBuffer values;
        private final int size;

        RawIntValues(Onnx.TensorProto tensorProto) {
            this.values = this.bytes(tensorProto).asIntBuffer();
            this.size = this.values.remaining();
        }

        @Override
        double get(int i) {
            return this.values.get(i);
        }

        @Override
        int size() {
            return this.size;
        }
    }

    private static class RawLongValues
    extends RawValues {
        private final LongBuffer values;
        private final int size;

        RawLongValues(Onnx.TensorProto tensorProto) {
            this.values = this.bytes(tensorProto).asLongBuffer();
            this.size = this.values.remaining();
        }

        @Override
        double get(int i) {
            return this.values.get(i);
        }

        @Override
        int size() {
            return this.size;
        }
    }

    private static class FloatValues
    extends Values {
        private final Onnx.TensorProto tensorProto;

        FloatValues(Onnx.TensorProto tensorProto) {
            this.tensorProto = tensorProto;
        }

        @Override
        double get(int i) {
            return this.tensorProto.getFloatData(i);
        }

        @Override
        int size() {
            return this.tensorProto.getFloatDataCount();
        }
    }

    private static class DoubleValues
    extends Values {
        private final Onnx.TensorProto tensorProto;

        DoubleValues(Onnx.TensorProto tensorProto) {
            this.tensorProto = tensorProto;
        }

        @Override
        double get(int i) {
            return this.tensorProto.getDoubleData(i);
        }

        @Override
        int size() {
            return this.tensorProto.getDoubleDataCount();
        }
    }

    private static class IntValues
    extends Values {
        private final Onnx.TensorProto tensorProto;

        IntValues(Onnx.TensorProto tensorProto) {
            this.tensorProto = tensorProto;
        }

        @Override
        double get(int i) {
            return this.tensorProto.getInt32Data(i);
        }

        @Override
        int size() {
            return this.tensorProto.getInt32DataCount();
        }
    }

    private static class LongValues
    extends Values {
        private final Onnx.TensorProto tensorProto;

        LongValues(Onnx.TensorProto tensorProto) {
            this.tensorProto = tensorProto;
        }

        @Override
        double get(int i) {
            return this.tensorProto.getInt64Data(i);
        }

        @Override
        int size() {
            return this.tensorProto.getInt64DataCount();
        }
    }

    private static abstract class RawValues
    extends Values {
        private RawValues() {
        }

        ByteBuffer bytes(Onnx.TensorProto tensorProto) {
            ByteString byteString = tensorProto.getRawData();
            return byteString.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        }
    }
}

