/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.evaluator;

import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;

public class OnnxEvaluatorOptions {
    private OrtSession.SessionOptions.OptLevel optimizationLevel = OrtSession.SessionOptions.OptLevel.ALL_OPT;
    private OrtSession.SessionOptions.ExecutionMode executionMode = OrtSession.SessionOptions.ExecutionMode.SEQUENTIAL;
    private int interOpThreads = 1;
    private int intraOpThreads = Math.max(1, (int)Math.ceil((double)Runtime.getRuntime().availableProcessors() / 4.0));
    private int gpuDeviceNumber = -1;
    private boolean gpuDeviceRequired = false;

    public OrtSession.SessionOptions getOptions(boolean loadCuda) throws OrtException {
        OrtSession.SessionOptions options = new OrtSession.SessionOptions();
        options.setOptimizationLevel(this.optimizationLevel);
        options.setExecutionMode(this.executionMode);
        options.setInterOpNumThreads(this.interOpThreads);
        options.setIntraOpNumThreads(this.intraOpThreads);
        if (loadCuda) {
            options.addCUDA(this.gpuDeviceNumber);
        }
        return options;
    }

    public void setExecutionMode(String mode) {
        if ("parallel".equalsIgnoreCase(mode)) {
            this.executionMode = OrtSession.SessionOptions.ExecutionMode.PARALLEL;
        } else if ("sequential".equalsIgnoreCase(mode)) {
            this.executionMode = OrtSession.SessionOptions.ExecutionMode.SEQUENTIAL;
        }
    }

    public void setInterOpThreads(int threads) {
        if (threads >= 0) {
            this.interOpThreads = threads;
        }
    }

    public void setIntraOpThreads(int threads) {
        if (threads >= 0) {
            this.intraOpThreads = threads;
        }
    }

    public void setGpuDevice(int deviceNumber, boolean required) {
        this.gpuDeviceNumber = deviceNumber;
        this.gpuDeviceRequired = required;
    }

    public boolean requestingGpu() {
        return this.gpuDeviceNumber > -1;
    }

    public boolean gpuDeviceRequired() {
        return this.gpuDeviceRequired;
    }
}

