/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.embedding.huggingface;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class HuggingFaceEmbedderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "8f47a2e2d5cda4eafd194217b19d6091";
    public static final String CONFIG_DEF_NAME = "hugging-face-embedder";
    public static final String CONFIG_DEF_NAMESPACE = "embedding.huggingface";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=embedding.huggingface", "tokenizerPath model", "transformerModel model", "transformerMaxTokens int default=512", "transformerInputIds string default=input_ids", "transformerAttentionMask string default=attention_mask", "transformerOutput string default=last_hidden_state"};
    private final ModelNode tokenizerPath;
    private final ModelNode transformerModel;
    private final IntegerNode transformerMaxTokens;
    private final StringNode transformerInputIds;
    private final StringNode transformerAttentionMask;
    private final StringNode transformerOutput;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public HuggingFaceEmbedderConfig(Builder builder) {
        this(builder, true);
    }

    private HuggingFaceEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for hugging-face-embedder must be initialized: " + builder.__uninitialized);
        }
        this.tokenizerPath = builder.tokenizerPath == null ? new ModelNode() : new ModelNode(builder.tokenizerPath);
        this.transformerModel = builder.transformerModel == null ? new ModelNode() : new ModelNode(builder.transformerModel);
        this.transformerMaxTokens = builder.transformerMaxTokens == null ? new IntegerNode(512) : new IntegerNode(builder.transformerMaxTokens.intValue());
        this.transformerInputIds = builder.transformerInputIds == null ? new StringNode("input_ids") : new StringNode(builder.transformerInputIds);
        this.transformerAttentionMask = builder.transformerAttentionMask == null ? new StringNode("attention_mask") : new StringNode(builder.transformerAttentionMask);
        this.transformerOutput = builder.transformerOutput == null ? new StringNode("last_hidden_state") : new StringNode(builder.transformerOutput);
    }

    public Path tokenizerPath() {
        return (Path)this.tokenizerPath.value();
    }

    public Path transformerModel() {
        return (Path)this.transformerModel.value();
    }

    public int transformerMaxTokens() {
        return this.transformerMaxTokens.value();
    }

    public String transformerInputIds() {
        return this.transformerInputIds.value();
    }

    public String transformerAttentionMask() {
        return this.transformerAttentionMask.value();
    }

    public String transformerOutput() {
        return this.transformerOutput.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(HuggingFaceEmbedderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("tokenizerPath", "transformerModel"));
        private ModelReference tokenizerPath = null;
        private ModelReference transformerModel = null;
        private Integer transformerMaxTokens = null;
        private String transformerInputIds = null;
        private String transformerAttentionMask = null;
        private String transformerOutput = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(HuggingFaceEmbedderConfig config) {
            this.tokenizerPath(config.tokenizerPath.getModelReference());
            this.transformerModel(config.transformerModel.getModelReference());
            this.transformerMaxTokens(config.transformerMaxTokens());
            this.transformerInputIds(config.transformerInputIds());
            this.transformerAttentionMask(config.transformerAttentionMask());
            this.transformerOutput(config.transformerOutput());
        }

        private Builder override(Builder __superior) {
            if (__superior.tokenizerPath != null) {
                this.tokenizerPath(__superior.tokenizerPath);
            }
            if (__superior.transformerModel != null) {
                this.transformerModel(__superior.transformerModel);
            }
            if (__superior.transformerMaxTokens != null) {
                this.transformerMaxTokens(__superior.transformerMaxTokens);
            }
            if (__superior.transformerInputIds != null) {
                this.transformerInputIds(__superior.transformerInputIds);
            }
            if (__superior.transformerAttentionMask != null) {
                this.transformerAttentionMask(__superior.transformerAttentionMask);
            }
            if (__superior.transformerOutput != null) {
                this.transformerOutput(__superior.transformerOutput);
            }
            return this;
        }

        public Builder tokenizerPath(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tokenizerPath = __value;
            this.__uninitialized.remove("tokenizerPath");
            return this;
        }

        public Builder transformerModel(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerModel = __value;
            this.__uninitialized.remove("transformerModel");
            return this;
        }

        public Builder transformerMaxTokens(int __value) {
            this.transformerMaxTokens = __value;
            return this;
        }

        private Builder transformerMaxTokens(String __value) {
            return this.transformerMaxTokens(Integer.valueOf(__value));
        }

        public Builder transformerInputIds(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerInputIds = __value;
            return this;
        }

        public Builder transformerAttentionMask(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerAttentionMask = __value;
            return this;
        }

        public Builder transformerOutput(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transformerOutput = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return HuggingFaceEmbedderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return HuggingFaceEmbedderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return HuggingFaceEmbedderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public HuggingFaceEmbedderConfig build() {
            return new HuggingFaceEmbedderConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

