/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.tensorflow;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.onnx.OnnxImporter;
import com.yahoo.collections.Pair;
import com.yahoo.io.IOUtils;
import com.yahoo.system.ProcessExecuter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;

public class TensorFlowImporter
extends ModelImporter {
    private static final Logger log = Logger.getLogger(TensorFlowImporter.class.getName());
    private static final int[] onnxOpsetsToTry = new int[]{12, 10, 8};
    private final OnnxImporter onnxImporter = new OnnxImporter();

    @Override
    public boolean canImport(String modelPath) {
        File modelDir = new File(modelPath);
        if (!modelDir.isDirectory()) {
            return false;
        }
        for (File file : modelDir.listFiles()) {
            if (file.toString().endsWith(".pbtxt")) {
                return true;
            }
            if (!file.toString().endsWith(".pb")) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImportedModel importModel(String modelName, String modelDir) {
        return this.convertToOnnxAndImport(modelName, modelDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImportedModel convertToOnnxAndImport(String modelName, String modelDir) {
        Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory("tf2onnx", new FileAttribute[0]);
            String convertedPath = tempDir.toString() + File.separatorChar + "converted.onnx";
            String outputOfLastConversionAttempt = "";
            int[] nArray = onnxOpsetsToTry;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int opset = nArray[n2];
                log.info("Converting TensorFlow model '" + modelDir + "' to ONNX with opset " + opset + "...");
                Pair<Integer, String> res = this.convertToOnnx(modelDir, convertedPath, opset);
                if ((Integer)res.getFirst() == 0) {
                    log.info("Conversion to ONNX with opset " + opset + " successful.");
                    ImportedModel importedModel = this.onnxImporter.importModelAsNative(modelName, convertedPath, ImportedMlModel.ModelType.TENSORFLOW);
                    return importedModel;
                }
                log.fine("Conversion to ONNX with opset " + opset + " failed. Reason: " + (String)res.getSecond());
                outputOfLastConversionAttempt = (String)res.getSecond();
                ++n2;
            }
            throw new IllegalArgumentException("Unable to convert TensorFlow model in '" + modelDir + "' to ONNX. Reason: " + outputOfLastConversionAttempt);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Conversion from TensorFlow to ONNX failed for '" + modelDir + "'");
        }
        finally {
            if (tempDir != null) {
                IOUtils.recursiveDeleteDir((File)tempDir.toFile());
            }
        }
    }

    private Pair<Integer, String> convertToOnnx(String savedModel, String output, int opset) throws IOException {
        ProcessExecuter executer = new ProcessExecuter();
        String job = "vespa-convert-tf2onnx --saved-model " + savedModel + " --output " + output + " --opset " + opset + " --use-graph-names";
        return executer.exec(job);
    }
}

