/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.configmodelview;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.configmodelview.MlModelImporter;
import com.yahoo.concurrent.InThreadExecutorService;
import com.yahoo.path.Path;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ImportedMlModels {
    private final Map<String, ImportedMlModel> importedModels;
    private final Map<String, String> skippedModels = new ConcurrentHashMap<String, String>();

    public ImportedMlModels() {
        this.importedModels = Collections.emptyMap();
    }

    @Deprecated
    public ImportedMlModels(File modelsDirectory, Collection<MlModelImporter> importers) {
        this(modelsDirectory, (ExecutorService)new InThreadExecutorService(), importers);
    }

    public ImportedMlModels(File modelsDirectory, ExecutorService executor, Collection<MlModelImporter> importers) {
        HashMap<String, Future<ImportedMlModel>> futureModels = new HashMap<String, Future<ImportedMlModel>>();
        ImportedMlModels.importRecursively(modelsDirectory, executor, futureModels, importers, this.skippedModels);
        HashMap models = new HashMap();
        futureModels.forEach((name, future) -> {
            try {
                ImportedMlModel model = (ImportedMlModel)future.get();
                if (model != null) {
                    models.put(name, model);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                this.skippedModels.put((String)name, e.getMessage());
            }
        });
        this.importedModels = Collections.unmodifiableMap(models);
    }

    public ImportedMlModel get(File modelPath) {
        return this.importedModels.get(ImportedMlModels.toName(modelPath));
    }

    public Collection<ImportedMlModel> all() {
        return this.importedModels.values();
    }

    public Map<String, String> getSkippedModels() {
        return this.skippedModels;
    }

    private static void importRecursively(File dir, ExecutorService executor, Map<String, Future<ImportedMlModel>> models, Collection<MlModelImporter> importers, Map<String, String> skippedModels) {
        if (!dir.isDirectory()) {
            return;
        }
        Arrays.stream(dir.listFiles()).sorted().forEach(child -> {
            Optional<MlModelImporter> importer = ImportedMlModels.findImporterOf(child, importers);
            if (importer.isPresent()) {
                String name = ImportedMlModels.toName(child);
                Future existing = (Future)models.get(name);
                if (existing != null) {
                    try {
                        throw new IllegalArgumentException("The models in " + child + " and " + ((ImportedMlModel)existing.get()).source() + " both resolve to the model name '" + name + "'");
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                }
                Future<ImportedMlModel> future = executor.submit(() -> {
                    try {
                        return ((MlModelImporter)importer.get()).importModel(name, (File)child);
                    }
                    catch (RuntimeException e) {
                        skippedModels.put(name, e.getMessage());
                        return null;
                    }
                });
                models.put(name, future);
            } else {
                ImportedMlModels.importRecursively(child, executor, models, importers, skippedModels);
            }
        });
    }

    private static Optional<MlModelImporter> findImporterOf(File path, Collection<MlModelImporter> importers) {
        return importers.stream().filter(item -> item.canImport(path.toString())).findFirst();
    }

    private static String toName(File modelFile) {
        Path modelPath = Path.fromString((String)modelFile.toString());
        if (modelFile.isFile()) {
            modelPath = ImportedMlModels.stripFileEnding(modelPath);
        }
        String localPath = ImportedMlModels.concatenateAfterModelsDirectory(modelPath);
        return localPath.replace('.', '_');
    }

    private static Path stripFileEnding(Path path) {
        int dotIndex = path.last().lastIndexOf(".");
        if (dotIndex <= 0) {
            return path;
        }
        return path.withLast(path.last().substring(0, dotIndex));
    }

    private static String concatenateAfterModelsDirectory(Path path) {
        boolean afterModels = false;
        StringBuilder result = new StringBuilder();
        for (String element : path.elements()) {
            if (afterModels) {
                result.append(element).append("_");
            }
            if (!element.equals("models")) continue;
            afterModels = true;
        }
        return result.substring(0, result.length() - 1);
    }
}

