/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;

public class Transpose
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributes;

    public Transpose(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributes) {
        super(modelName, nodeName, inputs);
        this.attributes = attributes;
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(1)) {
            return null;
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        OrderedTensorType.Builder typeBuilder = new OrderedTensorType.Builder(this.resultValueType());
        for (int i = 0; i < inputType.rank(); ++i) {
            int inputIndex = inputType.rank() - 1 - i;
            if (this.attributes.getList("perm").isPresent()) {
                inputIndex = (int)this.attributes.getList("perm").get().get(i).asDouble();
            }
            TensorType.Dimension inputDimension = inputType.dimensions().get(inputIndex);
            typeBuilder.add(TensorType.Dimension.indexed((String)inputDimension.name(), (long)((Long)inputDimension.size().get())));
        }
        OrderedTensorType result = typeBuilder.build();
        return typeBuilder.build();
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputFunctionsPresent(1)) {
            return null;
        }
        return ((IntermediateOperation)this.inputs.get(0)).function().orElse(null);
    }

    @Override
    public Transpose withInputs(List<IntermediateOperation> inputs) {
        return new Transpose(this.modelName(), this.name(), inputs, this.attributes);
    }

    @Override
    public String operationName() {
        return "Transpose";
    }
}

