/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.GeneratorLambdaFunctionNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Unsqueeze
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;
    private List<String> expandDimensions;

    public Unsqueeze(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
        if (attributeMap.getList("axes").isEmpty()) {
            throw new IllegalArgumentException("Unsqueeze in " + this.name + ": Required attribute 'axes' is missing.");
        }
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(1)) {
            return null;
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        Set dimensionsToInsert = this.attributeMap.getList("axes").get().stream().map(d -> (int)d.asDouble()).collect(Collectors.toSet());
        int rank = inputType.rank() + dimensionsToInsert.size();
        dimensionsToInsert = dimensionsToInsert.stream().map(d -> d < 0 ? rank + d : d).collect(Collectors.toSet());
        this.expandDimensions = new ArrayList<String>();
        OrderedTensorType.Builder typeBuilder = new OrderedTensorType.Builder(this.resultValueType());
        int inputDimensionIndex = 0;
        for (int expandedDimensionIndex = 0; expandedDimensionIndex < rank; ++expandedDimensionIndex) {
            if (dimensionsToInsert.contains(expandedDimensionIndex)) {
                this.addDimension(expandedDimensionIndex, typeBuilder);
                continue;
            }
            typeBuilder.add(inputType.dimensions().get(inputDimensionIndex));
            ++inputDimensionIndex;
        }
        return typeBuilder.build();
    }

    private void addDimension(int dimensionIndex, OrderedTensorType.Builder typeBuilder) {
        String name = String.format("%s_%d", this.vespaName(), dimensionIndex);
        this.expandDimensions.add(name);
        typeBuilder.add(TensorType.Dimension.indexed((String)name, (long)1L));
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputFunctionsPresent(1)) {
            return null;
        }
        TensorType.Builder typeBuilder = new TensorType.Builder(this.resultValueType());
        for (String name : this.expandDimensions) {
            typeBuilder.indexed(name, 1L);
        }
        TensorType generatedType = typeBuilder.build();
        ConstantNode generatedExpression = new ConstantNode((Value)new DoubleValue(1.0));
        Generate generatedFunction = new Generate(generatedType, (Function)new GeneratorLambdaFunctionNode(generatedType, (ExpressionNode)generatedExpression).asLongListToDoubleOperator());
        return new Join(this.inputs().get(0).function().get(), (TensorFunction)generatedFunction, ScalarFunctions.multiply());
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        this.addConstraintsFrom(this.type, renamer);
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        ArrayList<String> renamedDimensions = new ArrayList<String>(this.expandDimensions.size());
        for (String name : this.expandDimensions) {
            Optional<String> newName = renamer.dimensionNameOf(name);
            if (newName.isEmpty()) {
                return;
            }
            renamedDimensions.add(newName.get());
        }
        this.expandDimensions = renamedDimensions;
    }

    @Override
    public Unsqueeze withInputs(List<IntermediateOperation> inputs) {
        return new Unsqueeze(this.modelName(), this.name(), inputs, this.attributeMap);
    }

    @Override
    public String operationName() {
        return "Unsqueeze";
    }
}

