/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer;

import ai.vespa.rankingexpression.importer.IntermediateGraph;
import ai.vespa.rankingexpression.importer.NamingConstraintSolver;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import ai.vespa.rankingexpression.importer.operations.Rename;
import com.yahoo.collections.ListMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DimensionRenamer {
    private static final Logger log = Logger.getLogger(DimensionRenamer.class.getName());
    private final String dimensionPrefix;
    private final IntermediateGraph graph;
    private final Set<String> dimensions = new HashSet<String>();
    private final ListMap<Arc, Constraint> constraints = new ListMap();
    private Map<String, Integer> renames = null;

    public DimensionRenamer(IntermediateGraph graph) {
        this(graph, "d");
    }

    public DimensionRenamer(IntermediateGraph graph, String dimensionPrefix) {
        this.graph = graph;
        this.dimensionPrefix = dimensionPrefix;
    }

    public void addDimension(String name) {
        this.dimensions.add(name);
    }

    public void addConstraint(String from, String to, Constraint constraint, IntermediateOperation operation) {
        if (constraint instanceof EqualConstraint && from.equals(to)) {
            return;
        }
        Arc arc = new Arc(from, to, operation);
        this.constraints.put((Object)arc, (Object)constraint);
        this.constraints.put((Object)arc.opposite(), (Object)constraint.opposite());
    }

    void solve() {
        log.log(Level.FINE, () -> "Rename problem:\n" + DimensionRenamer.constraintsToString(this.constraints));
        this.renames = this.solve(100000);
        log.log(Level.FINE, () -> "Rename solution:\n" + DimensionRenamer.renamesToString(this.renames));
    }

    private Map<String, Integer> solve(int maxIterations) {
        Map<String, Integer> solution = this.solveWithOrWithoutSoftConstraints(maxIterations);
        if (solution != null) {
            return solution;
        }
        for (RenameTarget target : this.prioritizedRenameTargets()) {
            target.insertRename(this);
            solution = this.solveWithOrWithoutSoftConstraints(maxIterations);
            if (solution != null) {
                return solution;
            }
            target.uninsertRename(this);
        }
        throw new IllegalArgumentException("Could not find a dimension naming solution given constraints\n" + DimensionRenamer.constraintsToString(this.constraints));
    }

    private Map<String, Integer> solveWithOrWithoutSoftConstraints(int maxIterations) {
        ListMap hardConstraints;
        boolean anyRemoved;
        Map<String, Integer> solution = NamingConstraintSolver.solve(this.dimensions, this.constraints, maxIterations);
        if (solution == null && (anyRemoved = this.copyHard(this.constraints, (ListMap<Arc, Constraint>)(hardConstraints = new ListMap())))) {
            solution = NamingConstraintSolver.solve(this.dimensions, (ListMap<Arc, Constraint>)hardConstraints, maxIterations);
        }
        return solution;
    }

    private boolean copyHard(ListMap<Arc, Constraint> source, ListMap<Arc, Constraint> target) {
        boolean removed = false;
        for (Map.Entry entry : source.entrySet()) {
            Arc arc = (Arc)entry.getKey();
            for (Constraint constraint : (List)entry.getValue()) {
                if (!constraint.isSoft()) {
                    target.put((Object)arc, (Object)constraint);
                    continue;
                }
                removed = true;
            }
        }
        return removed;
    }

    private List<RenameTarget> prioritizedRenameTargets() {
        HashMap<IntermediateOperation, Integer> constraintsPerOperation = new HashMap<IntermediateOperation, Integer>();
        for (Map.Entry constraint : this.constraints.entrySet()) {
            constraintsPerOperation.compute(((Arc)constraint.getKey()).operation, (operation, count) -> {
                int n;
                if (count == null) {
                    n = 1;
                } else {
                    count = count + 1;
                    n = count;
                }
                return n;
            });
        }
        List prioritizedOperations = constraintsPerOperation.entrySet().stream().sorted(Comparator.comparingInt(entry -> -((Integer)entry.getValue()).intValue())).map(entry -> (IntermediateOperation)entry.getKey()).collect(Collectors.toList());
        ArrayList<RenameTarget> targets = new ArrayList<RenameTarget>();
        for (IntermediateOperation operation2 : prioritizedOperations) {
            for (int i = 0; i < operation2.inputs().size(); ++i) {
                Optional<OrderedTensorType> inputType = operation2.inputs().get(i).type();
                if (inputType.isEmpty()) continue;
                for (String dimensionName : inputType.get().dimensionNames()) {
                    RenameTarget target = new RenameTarget(operation2, i, dimensionName, this.graph);
                    if (target.rootKey == null) continue;
                    targets.add(target);
                }
            }
        }
        return targets;
    }

    public Optional<String> dimensionNameOf(String name) {
        if (this.renames == null || !this.renames.containsKey(name)) {
            return Optional.empty();
        }
        return Optional.of(String.format("%s%d", this.dimensionPrefix, this.renames.get(name)));
    }

    private static String renamesToString(Map<String, Integer> renames) {
        return renames.entrySet().stream().map(e -> "  " + (String)e.getKey() + " -> " + e.getValue()).collect(Collectors.joining("\n"));
    }

    private static String constraintsToString(ListMap<Arc, Constraint> constraints) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry entry : constraints.entrySet()) {
            Arc arc = (Arc)entry.getKey();
            for (Constraint constraint : (List)entry.getValue()) {
                if (constraint.isOpposite()) continue;
                b.append("  ");
                if (constraint.isSoft()) {
                    b.append("(soft) ");
                }
                b.append(arc.from).append(" ").append(constraint).append(" ").append(arc.to);
                b.append("  (origin: ").append(arc.operation).append(")\n");
            }
        }
        return b.toString();
    }

    private static class RenameTarget {
        final IntermediateOperation operation;
        final int inputNumber;
        final String dimensionName;
        final IntermediateGraph graph;
        final String rootKey;

        public RenameTarget(IntermediateOperation operation, int inputNumber, String dimensionName, IntermediateGraph graph) {
            this.operation = operation;
            this.inputNumber = inputNumber;
            this.dimensionName = dimensionName;
            this.rootKey = RenameTarget.findRootKey(operation, graph);
            this.graph = graph;
        }

        public IntermediateOperation input() {
            return this.operation.inputs().get(this.inputNumber);
        }

        private static String findRootKey(IntermediateOperation operation, IntermediateGraph graph) {
            for (Map.Entry<String, IntermediateOperation> entry : graph.operations().entrySet()) {
                if (entry.getValue() != operation) continue;
                return entry.getKey();
            }
            return null;
        }

        private boolean insertRename(DimensionRenamer renamer) {
            Rename rename = new Rename(this.operation.modelName(), this.dimensionName, renamer.dimensionPrefix + renamer.dimensions.size(), this.input());
            ArrayList<IntermediateOperation> newInputs = new ArrayList<IntermediateOperation>(this.operation.inputs());
            newInputs.set(this.inputNumber, rename);
            IntermediateOperation newOperation = this.operation.withInputs(newInputs);
            if (this.rootKey == null) {
                throw new IllegalStateException("Renaming non-roots is not implemented");
            }
            this.graph.put(this.rootKey, newOperation);
            this.removeConstraintsOf(this.operation, renamer);
            rename.addDimensionNameConstraints(renamer);
            newOperation.addDimensionNameConstraints(renamer);
            return true;
        }

        private void uninsertRename(DimensionRenamer renamer) {
            IntermediateOperation newOperation = this.graph.operations().get(this.rootKey);
            Rename rename = (Rename)newOperation.inputs().get(this.inputNumber);
            this.graph.put(this.rootKey, this.operation);
            this.removeConstraintsOf(rename, renamer);
            this.removeConstraintsOf(newOperation, renamer);
            this.operation.addDimensionNameConstraints(renamer);
        }

        private void removeConstraintsOf(IntermediateOperation operation, DimensionRenamer renamer) {
            for (Arc key : new HashSet(renamer.constraints.keySet())) {
                if (key.operation != operation) continue;
                renamer.constraints.removeAll((Object)key);
            }
        }

        public String toString() {
            return this.operation + ", input " + this.inputNumber;
        }
    }

    private static class GreaterThanConstraint
    extends Constraint {
        private GreaterThanConstraint(boolean soft, boolean opposite) {
            super(soft, opposite);
        }

        @Override
        public boolean test(Integer x, Integer y) {
            return x > y;
        }

        @Override
        public Constraint opposite() {
            return new LessThanConstraint(this.isSoft(), true);
        }

        public String toString() {
            return ">";
        }
    }

    private static class LessThanConstraint
    extends Constraint {
        private LessThanConstraint(boolean soft, boolean opposite) {
            super(soft, opposite);
        }

        @Override
        public boolean test(Integer x, Integer y) {
            return x < y;
        }

        @Override
        public Constraint opposite() {
            return new GreaterThanConstraint(this.isSoft(), true);
        }

        public String toString() {
            return "<";
        }
    }

    private static class NotEqualConstraint
    extends Constraint {
        private NotEqualConstraint(boolean soft, boolean opposite) {
            super(soft, opposite);
        }

        @Override
        public boolean test(Integer x, Integer y) {
            return !Objects.equals(x, y);
        }

        @Override
        public Constraint opposite() {
            return new NotEqualConstraint(this.isSoft(), true);
        }

        public String toString() {
            return "!=";
        }
    }

    private static class EqualConstraint
    extends Constraint {
        private EqualConstraint(boolean soft, boolean opposite) {
            super(soft, opposite);
        }

        @Override
        public boolean test(Integer x, Integer y) {
            return Objects.equals(x, y);
        }

        @Override
        public Constraint opposite() {
            return new EqualConstraint(this.isSoft(), true);
        }

        public String toString() {
            return "==";
        }
    }

    public static abstract class Constraint {
        private final boolean soft;
        private final boolean opposite;

        protected Constraint(boolean soft, boolean opposite) {
            this.soft = soft;
            this.opposite = opposite;
        }

        abstract boolean test(Integer var1, Integer var2);

        abstract Constraint opposite();

        boolean isSoft() {
            return this.soft;
        }

        boolean isOpposite() {
            return this.opposite;
        }

        public static Constraint equal(boolean soft) {
            return new EqualConstraint(soft, false);
        }

        public static Constraint notEqual(boolean soft) {
            return new NotEqualConstraint(soft, false);
        }

        public static Constraint lessThan(boolean soft) {
            return new LessThanConstraint(soft, false);
        }

        public static Constraint greaterThan(boolean soft) {
            return new GreaterThanConstraint(soft, false);
        }
    }

    static class Arc {
        final String from;
        final String to;
        private final IntermediateOperation operation;

        Arc(String from, String to, IntermediateOperation operation) {
            this.from = from;
            this.to = to;
            this.operation = operation;
        }

        Arc opposite() {
            return new Arc(this.to, this.from, this.operation);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Arc)) {
                return false;
            }
            Arc other = (Arc)obj;
            return Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to);
        }

        public String toString() {
            return this.from + " -> " + this.to;
        }
    }
}

