/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.FunctionEvaluator;
import ai.vespa.models.evaluation.Model;
import ai.vespa.models.evaluation.RankProfilesConfigImporter;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.yahoo.api.annotations.Beta;
import com.yahoo.component.AbstractComponent;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import java.util.Map;

@Beta
public class ModelsEvaluator
extends AbstractComponent {
    private final ImmutableMap<String, Model> models;

    @Inject
    public ModelsEvaluator(RankProfilesConfig config, RankingConstantsConfig constantsConfig, RankingExpressionsConfig expressionsConfig, OnnxModelsConfig onnxModelsConfig, FileAcquirer fileAcquirer) {
        this(new RankProfilesConfigImporter(fileAcquirer), config, constantsConfig, expressionsConfig, onnxModelsConfig);
    }

    public ModelsEvaluator(RankProfilesConfigImporter importer, RankProfilesConfig config, RankingConstantsConfig constantsConfig, RankingExpressionsConfig expressionsConfig, OnnxModelsConfig onnxModelsConfig) {
        this(importer.importFrom(config, constantsConfig, expressionsConfig, onnxModelsConfig));
    }

    public ModelsEvaluator(Map<String, Model> models) {
        this.models = ImmutableMap.copyOf(models);
    }

    public Map<String, Model> models() {
        return this.models;
    }

    public FunctionEvaluator evaluatorOf(String modelName, String ... names) {
        return this.requireModel(modelName).evaluatorOf(names);
    }

    public Model requireModel(String name) {
        Model model = (Model)this.models.get((Object)name);
        if (model == null) {
            throw new IllegalArgumentException("No model named '" + name + "'. Available models: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)this.models.keySet()));
        }
        return model;
    }
}

