/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.Constant;
import ai.vespa.models.evaluation.FunctionReference;
import ai.vespa.models.evaluation.Model;
import com.yahoo.config.FileReference;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.io.IOUtils;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class RankProfilesConfigImporter {
    private final FileAcquirer fileAcquirer;

    public RankProfilesConfigImporter(FileAcquirer fileAcquirer) {
        this.fileAcquirer = fileAcquirer;
    }

    public Map<String, Model> importFrom(RankProfilesConfig config, RankingConstantsConfig constantsConfig) {
        try {
            HashMap<String, Model> models = new HashMap<String, Model>();
            for (RankProfilesConfig.Rankprofile profile : config.rankprofile()) {
                Model model = this.importProfile(profile, constantsConfig);
                models.put(model.name(), model);
            }
            return models;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not read rank profiles config - version mismatch?", e);
        }
    }

    private Model importProfile(RankProfilesConfig.Rankprofile profile, RankingConstantsConfig constantsConfig) throws ParseException {
        ArrayList<ExpressionFunction> functions = new ArrayList<ExpressionFunction>();
        HashMap<FunctionReference, ExpressionFunction> referencedFunctions = new HashMap<FunctionReference, ExpressionFunction>();
        ExpressionFunction firstPhase = null;
        ExpressionFunction secondPhase = null;
        List<Constant> constants = this.readConstants(constantsConfig);
        for (RankProfilesConfig.Rankprofile.Fef.Property property : profile.fef().property()) {
            Optional<FunctionReference> reference = FunctionReference.fromSerial(property.name());
            if (reference.isPresent()) {
                ArrayList arguments = new ArrayList();
                RankingExpression expression = new RankingExpression(reference.get().functionName(), property.value());
                if (reference.get().isFree()) {
                    functions.add(new ExpressionFunction(reference.get().functionName(), arguments, expression));
                }
                referencedFunctions.put(reference.get(), new ExpressionFunction(reference.get().serialForm(), arguments, expression));
                continue;
            }
            if (property.name().equals("vespa.rank.firstphase")) {
                firstPhase = new ExpressionFunction("firstphase", new ArrayList(), new RankingExpression("first-phase", property.value()));
                continue;
            }
            if (!property.name().equals("vespa.rank.secondphase")) continue;
            secondPhase = new ExpressionFunction("secondphase", new ArrayList(), new RankingExpression("second-phase", property.value()));
        }
        if (this.functionByName("firstphase", functions) == null && firstPhase != null) {
            functions.add(firstPhase);
        }
        if (this.functionByName("secondphase", functions) == null && secondPhase != null) {
            functions.add(secondPhase);
        }
        try {
            return new Model(profile.name(), functions, referencedFunctions, constants);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not load model '" + profile.name() + "'", e);
        }
    }

    private ExpressionFunction functionByName(String name, List<ExpressionFunction> functions) {
        for (ExpressionFunction function : functions) {
            if (!function.getName().equals(name)) continue;
            return function;
        }
        return null;
    }

    private List<Constant> readConstants(RankingConstantsConfig constantsConfig) {
        ArrayList<Constant> constants = new ArrayList<Constant>();
        for (RankingConstantsConfig.Constant constantConfig : constantsConfig.constant()) {
            constants.add(new Constant(constantConfig.name(), this.readTensorFromFile(constantConfig.name(), TensorType.fromSpec((String)constantConfig.type()), constantConfig.fileref())));
        }
        return constants;
    }

    protected Tensor readTensorFromFile(String name, TensorType type, FileReference fileReference) {
        try {
            File file = this.fileAcquirer.waitFor(fileReference, 7L, TimeUnit.DAYS);
            if (file.getName().endsWith(".tbf")) {
                return TypedBinaryFormat.decode(Optional.of(type), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])IOUtils.readFileBytes((File)file)));
            }
            throw new IllegalArgumentException("Constant files on other formats than .tbf are not supported, got " + file + " for constant " + name);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Gave up waiting for constant " + name);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

