/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.FunctionEvaluator;
import ai.vespa.models.evaluation.FunctionReference;
import ai.vespa.models.evaluation.LazyArrayContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.evaluation.ContextIndex;
import com.yahoo.searchlib.rankingexpression.evaluation.ExpressionOptimizer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Model {
    private final String name;
    private final ImmutableList<ExpressionFunction> functions;
    private final ImmutableMap<FunctionReference, ExpressionFunction> referencedFunctions;
    private final ImmutableMap<String, LazyArrayContext> contextPrototypes;
    private final ExpressionOptimizer expressionOptimizer = new ExpressionOptimizer();

    public Model(String name, Collection<ExpressionFunction> functions) {
        this(name, functions, Collections.emptyMap());
    }

    Model(String name, Collection<ExpressionFunction> functions, Map<FunctionReference, ExpressionFunction> referencedFunctions) {
        this.name = name;
        this.functions = ImmutableList.copyOf(functions);
        ImmutableMap.Builder contextBuilder = new ImmutableMap.Builder();
        for (ExpressionFunction function : functions) {
            try {
                contextBuilder.put((Object)function.getName(), (Object)new LazyArrayContext(function.getBody(), referencedFunctions, this));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Could not prepare an evaluation context for " + function, e);
            }
        }
        this.contextPrototypes = contextBuilder.build();
        ImmutableMap.Builder functionsBuilder = new ImmutableMap.Builder();
        for (Map.Entry<FunctionReference, ExpressionFunction> function : referencedFunctions.entrySet()) {
            ExpressionFunction optimizedFunction = this.optimize(function.getValue(), (ContextIndex)this.contextPrototypes.get((Object)function.getKey().functionName()));
            functionsBuilder.put((Object)function.getKey(), (Object)optimizedFunction);
        }
        this.referencedFunctions = functionsBuilder.build();
    }

    private ExpressionFunction optimize(ExpressionFunction function, ContextIndex context) {
        this.expressionOptimizer.optimize(function.getBody(), context);
        return function;
    }

    public String name() {
        return this.name;
    }

    public List<ExpressionFunction> functions() {
        return this.functions;
    }

    ExpressionFunction requireFunction(String name) {
        ExpressionFunction function = this.function(name);
        if (function == null) {
            throw new IllegalArgumentException("No function named '" + name + "' in " + this + ". Available functions: " + this.functions.stream().map(f -> f.getName()).collect(Collectors.joining(", ")));
        }
        return function;
    }

    private LazyArrayContext requireContextProprotype(String name) {
        LazyArrayContext context = (LazyArrayContext)((Object)this.contextPrototypes.get((Object)name));
        if (context == null) {
            throw new IllegalArgumentException("No function named '" + name + "' in " + this + ". Available functions: " + this.functions.stream().map(f -> f.getName()).collect(Collectors.joining(", ")));
        }
        return context;
    }

    ExpressionFunction function(String name) {
        for (ExpressionFunction function : this.functions) {
            if (!function.getName().equals(name)) continue;
            return function;
        }
        return null;
    }

    Map<FunctionReference, ExpressionFunction> referencedFunctions() {
        return this.referencedFunctions;
    }

    ExpressionFunction requireReferencedFunction(FunctionReference reference) {
        ExpressionFunction function = (ExpressionFunction)this.referencedFunctions.get((Object)reference);
        if (function == null) {
            throw new IllegalArgumentException("No " + reference + " in " + this + ". References: " + this.referencedFunctions.keySet().stream().map(FunctionReference::serialForm).collect(Collectors.joining(", ")));
        }
        return function;
    }

    public FunctionEvaluator evaluatorOf(String function) {
        return new FunctionEvaluator(this.requireFunction(function), this.requireContextProprotype(function).copy());
    }

    public String toString() {
        return "model '" + this.name + "'";
    }
}

