/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.metrics;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MetricsmanagerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "ea7f889d45f793408ebcd4d946050902";
    public static final String CONFIG_DEF_NAME = "metricsmanager";
    public static final String CONFIG_DEF_NAMESPACE = "metrics";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=metrics", "snapshot.periods[] int restart", "consumer[].name string restart", "consumer[].tags[] string restart", "consumer[].removedtags[] string restart", "consumer[].addedmetrics[] string restart", "consumer[].removedmetrics[] string restart"};
    private final Snapshot snapshot;
    private final InnerNodeVector<Consumer> consumer;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public MetricsmanagerConfig(Builder builder) {
        this(builder, true);
    }

    private MetricsmanagerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for metricsmanager must be initialized: " + builder.__uninitialized);
        }
        this.snapshot = new Snapshot(builder.snapshot, throwIfUninitialized);
        this.consumer = Consumer.createVector(builder.consumer);
    }

    public Snapshot snapshot() {
        return this.snapshot;
    }

    public List<Consumer> consumer() {
        return this.consumer;
    }

    public Consumer consumer(int i) {
        return (Consumer)((Object)this.consumer.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(MetricsmanagerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.mergeChanges("snapshot", this.snapshot.getChangesRequiringRestart(newConfig.snapshot));
        changes.compareArray(this.consumer, newConfig.consumer, "consumer", CONFIG_DEF_VERSION, (a, b) -> ((Consumer)a).getChangesRequiringRestart((Consumer)b));
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Consumer
    extends InnerNode {
        private final StringNode name;
        private final LeafNodeVector<String, StringNode> tags;
        private final LeafNodeVector<String, StringNode> removedtags;
        private final LeafNodeVector<String, StringNode> addedmetrics;
        private final LeafNodeVector<String, StringNode> removedmetrics;

        public Consumer(Builder builder) {
            this(builder, true);
        }

        private Consumer(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for metricsmanager.consumer[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.tags = new LeafNodeVector(builder.tags, (LeafNode)new StringNode());
            this.removedtags = new LeafNodeVector(builder.removedtags, (LeafNode)new StringNode());
            this.addedmetrics = new LeafNodeVector(builder.addedmetrics, (LeafNode)new StringNode());
            this.removedmetrics = new LeafNodeVector(builder.removedmetrics, (LeafNode)new StringNode());
        }

        public String name() {
            return this.name.value();
        }

        public List<String> tags() {
            return this.tags.asList();
        }

        public String tags(int i) {
            return ((StringNode)this.tags.get(i)).value();
        }

        public List<String> removedtags() {
            return this.removedtags.asList();
        }

        public String removedtags(int i) {
            return ((StringNode)this.removedtags.get(i)).value();
        }

        public List<String> addedmetrics() {
            return this.addedmetrics.asList();
        }

        public String addedmetrics(int i) {
            return ((StringNode)this.addedmetrics.get(i)).value();
        }

        public List<String> removedmetrics() {
            return this.removedmetrics.asList();
        }

        public String removedmetrics(int i) {
            return ((StringNode)this.removedmetrics.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Consumer newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("consumer");
            changes.compare((Node)this.name, (Node)newConfig.name, "name", "The name of the consumer that should include the given metrics specified.\nrestart flag was added automatically and needs to be verified.");
            changes.compareArray(this.tags, newConfig.tags, "tags", "Include metrics that match the given tags.\n \nA tag specification either adds a single tag by given the full tag name, or\nany tag, by specifying an asterix as wildcard ('*'). An asterix will not match\nmetrics without any tags set, but you can match these by specifying an empty\nstring.\n \nA metric set matched by tags, will also include every metric contained in it\nregardless of tags.\nrestart flag was added automatically and needs to be verified.", (a, b) -> new ChangesRequiringRestart("tags").compare(a, b, MetricsmanagerConfig.CONFIG_DEF_VERSION, "Include metrics that match the given tags.\n \nA tag specification either adds a single tag by given the full tag name, or\nany tag, by specifying an asterix as wildcard ('*'). An asterix will not match\nmetrics without any tags set, but you can match these by specifying an empty\nstring.\n \nA metric set matched by tags, will also include every metric contained in it\nregardless of tags.\nrestart flag was added automatically and needs to be verified."));
            changes.compareArray(this.removedtags, newConfig.removedtags, "removedtags", "Do not include metrics that match the specific tags. This has higher\npresedence than the adding of tags, but lower presedence than name patterns.\n \nRemoved tags are specified as added tags, with a small exception. Removing\nwildcard or untagged metrics does not make sense, as metrics are not added by\ndefault. If you don not want to include these metrics, just not specify them\nas tags to be added. Thus, these are not allowed in remove tags spec.\n \nA metric set matched by remove tag will remove all metrics below that tag.\nrestart flag was added automatically and needs to be verified.", (a, b) -> new ChangesRequiringRestart("removedtags").compare(a, b, MetricsmanagerConfig.CONFIG_DEF_VERSION, "Do not include metrics that match the specific tags. This has higher\npresedence than the adding of tags, but lower presedence than name patterns.\n \nRemoved tags are specified as added tags, with a small exception. Removing\nwildcard or untagged metrics does not make sense, as metrics are not added by\ndefault. If you don not want to include these metrics, just not specify them\nas tags to be added. Thus, these are not allowed in remove tags spec.\n \nA metric set matched by remove tag will remove all metrics below that tag.\nrestart flag was added automatically and needs to be verified."));
            changes.compareArray(this.addedmetrics, newConfig.addedmetrics, "addedmetrics", "Include all metrics that matches the names given here.\nMetrics added here have presedence above tag specifications.\n \nNames are specified as a complete dot separated path to metric. Asterix can\nbe used to match any part. An asterix will only match a complete name without\na dot. So if you have an average metric called 'queuesize' in your top level\nmetric set called 'myapp', you can add this metric with the spec\n'myapp.queuesize'. You can also add non-default average metric entries by\nspecifying which, such as 'myapp.queuesize.last' or 'myapp.queuesize.max'.\nPatterns can be used, to for instance specify '*.queuesize', 'myapp.*', '*.*',\n'myapp.*.max' or similar.\n \nA metric set added with specific name will add all metrics within it.\nrestart flag was added automatically and needs to be verified.", (a, b) -> new ChangesRequiringRestart("addedmetrics").compare(a, b, MetricsmanagerConfig.CONFIG_DEF_VERSION, "Include all metrics that matches the names given here.\nMetrics added here have presedence above tag specifications.\n \nNames are specified as a complete dot separated path to metric. Asterix can\nbe used to match any part. An asterix will only match a complete name without\na dot. So if you have an average metric called 'queuesize' in your top level\nmetric set called 'myapp', you can add this metric with the spec\n'myapp.queuesize'. You can also add non-default average metric entries by\nspecifying which, such as 'myapp.queuesize.last' or 'myapp.queuesize.max'.\nPatterns can be used, to for instance specify '*.queuesize', 'myapp.*', '*.*',\n'myapp.*.max' or similar.\n \nA metric set added with specific name will add all metrics within it.\nrestart flag was added automatically and needs to be verified."));
            changes.compareArray(this.removedmetrics, newConfig.removedmetrics, "removedmetrics", "Do not include metrics with the below names.\nThis has highest presedence. Metrics removed like this will override any\nspecification otherwise that would include them.\n \nThe remove metrics are specified exactly the same as the added metrics.\n \nA metric set removed with specific name will remove all metrics within it.\nrestart flag was added automatically and needs to be verified.", (a, b) -> new ChangesRequiringRestart("removedmetrics").compare(a, b, MetricsmanagerConfig.CONFIG_DEF_VERSION, "Do not include metrics with the below names.\nThis has highest presedence. Metrics removed like this will override any\nspecification otherwise that would include them.\n \nThe remove metrics are specified exactly the same as the added metrics.\n \nA metric set removed with specific name will remove all metrics within it.\nrestart flag was added automatically and needs to be verified."));
            return changes;
        }

        private static InnerNodeVector<Consumer> createVector(List<Builder> builders) {
            ArrayList<Consumer> elems = new ArrayList<Consumer>();
            for (Builder b : builders) {
                elems.add(new Consumer(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            public List<String> tags = new ArrayList<String>();
            public List<String> removedtags = new ArrayList<String>();
            public List<String> addedmetrics = new ArrayList<String>();
            public List<String> removedmetrics = new ArrayList<String>();

            public Builder() {
            }

            public Builder(Consumer config) {
                this.name(config.name());
                this.tags(config.tags());
                this.removedtags(config.removedtags());
                this.addedmetrics(config.addedmetrics());
                this.removedmetrics(config.removedmetrics());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (!__superior.tags.isEmpty()) {
                    this.tags.addAll(__superior.tags);
                }
                if (!__superior.removedtags.isEmpty()) {
                    this.removedtags.addAll(__superior.removedtags);
                }
                if (!__superior.addedmetrics.isEmpty()) {
                    this.addedmetrics.addAll(__superior.addedmetrics);
                }
                if (!__superior.removedmetrics.isEmpty()) {
                    this.removedmetrics.addAll(__superior.removedmetrics);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder tags(String __value) {
                this.tags.add(__value);
                return this;
            }

            public Builder tags(Collection<String> __values) {
                this.tags.addAll(__values);
                return this;
            }

            public Builder removedtags(String __value) {
                this.removedtags.add(__value);
                return this;
            }

            public Builder removedtags(Collection<String> __values) {
                this.removedtags.addAll(__values);
                return this;
            }

            public Builder addedmetrics(String __value) {
                this.addedmetrics.add(__value);
                return this;
            }

            public Builder addedmetrics(Collection<String> __values) {
                this.addedmetrics.addAll(__values);
                return this;
            }

            public Builder removedmetrics(String __value) {
                this.removedmetrics.add(__value);
                return this;
            }

            public Builder removedmetrics(Collection<String> __values) {
                this.removedmetrics.addAll(__values);
                return this;
            }

            public Consumer build() {
                return new Consumer(this);
            }
        }
    }

    public static final class Snapshot
    extends InnerNode {
        private final LeafNodeVector<Integer, IntegerNode> periods;

        public Snapshot(Builder builder) {
            this(builder, true);
        }

        private Snapshot(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for metricsmanager.snapshot must be initialized: " + builder.__uninitialized);
            }
            this.periods = new LeafNodeVector(builder.periods, (LeafNode)new IntegerNode());
        }

        public List<Integer> periods() {
            return this.periods.asList();
        }

        public int periods(int i) {
            return ((IntegerNode)this.periods.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Snapshot newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("snapshot");
            changes.compareArray(this.periods, newConfig.periods, "periods", "If any snapshot periods is set, these override all the default ones.\nThe array sets the snapshot periods in number of seconds. Note that when\nsorted in rising time length order, it is required that the snapshot length of\nthe next snapshot is a multiplum of the previous snapshot.\nrestart flag was added automatically and needs to be verified.", (a, b) -> new ChangesRequiringRestart("periods").compare(a, b, MetricsmanagerConfig.CONFIG_DEF_VERSION, "If any snapshot periods is set, these override all the default ones.\nThe array sets the snapshot periods in number of seconds. Note that when\nsorted in rising time length order, it is required that the snapshot length of\nthe next snapshot is a multiplum of the previous snapshot.\nrestart flag was added automatically and needs to be verified."));
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public List<Integer> periods = new ArrayList<Integer>();

            public Builder() {
            }

            public Builder(Snapshot config) {
                this.periods(config.periods());
            }

            private Builder override(Builder __superior) {
                if (!__superior.periods.isEmpty()) {
                    this.periods.addAll(__superior.periods);
                }
                return this;
            }

            public Builder periods(Integer __value) {
                this.periods.add(__value);
                return this;
            }

            public Builder periods(Collection<Integer> __values) {
                this.periods.addAll(__values);
                return this;
            }

            private Builder periods(String __value) {
                return this.periods(Integer.valueOf(__value));
            }

            public Snapshot build() {
                return new Snapshot(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Snapshot.Builder snapshot = new Snapshot.Builder();
        public List<Consumer.Builder> consumer = new ArrayList<Consumer.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(MetricsmanagerConfig config) {
            this.snapshot(new Snapshot.Builder(config.snapshot()));
            for (Consumer c : config.consumer()) {
                this.consumer(new Consumer.Builder(c));
            }
        }

        private Builder override(Builder __superior) {
            this.snapshot(this.snapshot.override(__superior.snapshot));
            if (!__superior.consumer.isEmpty()) {
                this.consumer.addAll(__superior.consumer);
            }
            return this;
        }

        public Builder snapshot(Snapshot.Builder __builder) {
            this.snapshot = __builder;
            return this;
        }

        public Builder consumer(Consumer.Builder __builder) {
            this.consumer.add(__builder);
            return this;
        }

        public Builder consumer(List<Consumer.Builder> __builders) {
            this.consumer = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return MetricsmanagerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return MetricsmanagerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return MetricsmanagerConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public MetricsmanagerConfig build() {
            return new MetricsmanagerConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

